/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnReadPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

final class CursorFactory {
    private final MuninnPagedFile pagedFile;
    private final long victimPage;
    private final VersionContextSupplier versionContextSupplier;

    CursorFactory(MuninnPagedFile pagedFile, VersionContextSupplier versionContextSupplier) {
        this.pagedFile = pagedFile;
        this.victimPage = pagedFile.pageCache.victimPage;
        this.versionContextSupplier = versionContextSupplier;
    }

    MuninnReadPageCursor takeReadCursor(long pageId, int pf_flags, PageCursorTracer pageCursorTracer) {
        MuninnReadPageCursor cursor = new MuninnReadPageCursor(this.victimPage, pageCursorTracer, this.versionContextSupplier);
        cursor.initialise(this.pagedFile, pageId, pf_flags);
        return cursor;
    }

    MuninnWritePageCursor takeWriteCursor(long pageId, int pf_flags, PageCursorTracer pageCursorTracer) {
        MuninnWritePageCursor cursor = new MuninnWritePageCursor(this.victimPage, pageCursorTracer, this.versionContextSupplier);
        cursor.initialise(this.pagedFile, pageId, pf_flags);
        return cursor;
    }
}

