/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;

class ByteUnitTest {
    ByteUnitTest() {
    }

    @Test
    void convertZero() {
        Assertions.assertThat((long)ByteUnit.Byte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.Byte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.Byte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.Byte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.Byte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.Byte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.Byte.toExbiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toExbiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toExbiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toExbiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toExbiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toExbiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toKibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toMebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toGibiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toTebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toPebiBytes(0L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toExbiBytes(0L)).isEqualTo(0L);
    }

    @Test
    void convertOneToEIC() {
        Assertions.assertThat((long)ByteUnit.KibiByte.toBytes(1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toKibiBytes(1L)).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toMebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toGibiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toTebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toPebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.KibiByte.toExbiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toBytes(1L)).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toKibiBytes(1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toMebiBytes(1L)).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toGibiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toTebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toPebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.MebiByte.toExbiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toBytes(1L)).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toKibiBytes(1L)).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toMebiBytes(1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toGibiBytes(1L)).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toTebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toPebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.GibiByte.toExbiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toBytes(1L)).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toKibiBytes(1L)).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toMebiBytes(1L)).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toGibiBytes(1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toTebiBytes(1L)).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toPebiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.TebiByte.toExbiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toBytes(1L)).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toKibiBytes(1L)).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toMebiBytes(1L)).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toGibiBytes(1L)).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toTebiBytes(1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toPebiBytes(1L)).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.PebiByte.toExbiBytes(1L)).isEqualTo(0L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toBytes(1L)).isEqualTo(0x1000000000000000L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toKibiBytes(1L)).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toMebiBytes(1L)).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toGibiBytes(1L)).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toTebiBytes(1L)).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toPebiBytes(1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.ExbiByte.toExbiBytes(1L)).isEqualTo(1L);
    }

    @Test
    void unitsAsBytes() {
        Assertions.assertThat((long)ByteUnit.bytes((long)1L)).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.kibiBytes((long)1L)).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.mebiBytes((long)1L)).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.gibiBytes((long)1L)).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.tebiBytes((long)1L)).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.pebiBytes((long)1L)).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.exbiBytes((long)1L)).isEqualTo(0x1000000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1")).isEqualTo(1L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 KiB")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1KiB")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 KB")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1KB")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    KB ")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 kB")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1kB")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    kB ")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 kb")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1kb")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    kb ")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 k")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1k")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    k")).isEqualTo(1024L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 MiB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1MiB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 MB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1MB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    MB ")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 mB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1mB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    mB ")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 mb")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1mb")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    mb ")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 m")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1m")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    m")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 GiB")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1GiB")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 GB")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1GB")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    GB ")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 gB")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1gB")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    gB ")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 gb")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1gb")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    gb ")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 g")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1g")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    g")).isEqualTo(0x40000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 TiB")).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1TiB")).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 TB")).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1TB")).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    TB ")).isEqualTo(0x10000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 PiB")).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1PiB")).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 PB")).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1PB")).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    PB ")).isEqualTo(0x4000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 EiB")).isEqualTo(0x1000000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1EiB")).isEqualTo(0x1000000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1 EB")).isEqualTo(0x1000000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1EB")).isEqualTo(0x1000000000000000L);
        Assertions.assertThat((long)ByteUnit.parse((String)" 1    EB ")).isEqualTo(0x1000000000000000L);
    }

    @Test
    void decimalUnitsToBytes() {
        Assertions.assertThat((long)ByteUnit.parse((String)"0.5KiB")).isEqualTo(512L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1.5KiB")).isEqualTo(1536L);
        Assertions.assertThat((long)ByteUnit.parse((String)"  1.5    KiB")).isEqualTo(1536L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1.57KiB")).isEqualTo(1607L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1.578945TiB")).isEqualTo(1736068387118L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1.0MiB")).isEqualTo(0x100000L);
        Assertions.assertThat((long)ByteUnit.parse((String)"1.000MiB")).isEqualTo(0x100000L);
    }

    @Test
    void parseShouldThrowOnOverflow() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"100000000.00TiB"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"92233720368547758071"));
    }

    @Test
    void parseShouldThrowOnNegativeValues() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"-100000000.00TiB"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"-1"));
    }

    @Test
    void bytesToString() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1B", (Object)ByteUnit.bytesToString((long)1L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10B", (Object)ByteUnit.bytesToString((long)10L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1000B", (Object)ByteUnit.bytesToString((long)1000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.001KiB", (Object)ByteUnit.bytesToString((long)1025L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.01KiB", (Object)ByteUnit.bytesToString((long)10250L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"100.1KiB", (Object)ByteUnit.bytesToString((long)102500L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1001KiB", (Object)ByteUnit.bytesToString((long)1025000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"9.775MiB", (Object)ByteUnit.bytesToString((long)10250000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"97.75MiB", (Object)ByteUnit.bytesToString((long)102500000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"977.5MiB", (Object)ByteUnit.bytesToString((long)1025000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"9.546GiB", (Object)ByteUnit.bytesToString((long)10250000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8.389e+06TiB", (Object)ByteUnit.bytesToString((long)Long.MAX_VALUE));
    }

    @Test
    void bytesToStringWithoutScientificNotation() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1B", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)1L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10B", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)10L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1000B", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)1000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.00KiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)1025L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.01KiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)10250L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"100.10KiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)102500L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1000.98KiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)1025000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"9.78MiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)10250000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"97.75MiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)102500000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"977.52MiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)1025000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"9.55GiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)10250000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"93.22TiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)102500000000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8388608.00TiB", (Object)ByteUnit.bytesToStringWithoutScientificNotation((long)Long.MAX_VALUE));
    }

    @Test
    void mustThrowWhenParsingInvalidUnit() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 XB"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 Ki B"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 Mi B"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 Gi B"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 Ti B"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 Pi B"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1 Ei B"));
    }

    @Test
    void mustThrowWhenParsingUnitInterjectedWithNumber() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"1K2i3B"));
    }

    @Test
    void mustThrowWhenParsingNonNumericTest() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"abc"));
    }

    @Test
    void mustThrowWhenParsingOnlyUnit() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"MiB"));
    }

    @Test
    void mustThrowWhenParsingUnitBeforeValue() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUnit.parse((String)"MiB 1"));
    }
}

