/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.bufferpool.impl.NeoBufferPoolConfigOverride;
import org.neo4j.io.bufferpool.impl.NeoByteBufferPool;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

class MemoryMonitoringTest {
    private final MemoryPools memoryPools = new MemoryPools();
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final ArgumentCaptor<Runnable> collectionRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
    private NeoByteBufferPool bufferPool;
    private MemoryPool memoryPool;

    MemoryMonitoringTest() {
    }

    @BeforeEach
    void setUp() {
        List<String> buckets = List.of("1K:1", "2K:1", "4K:1");
        NeoBufferPoolConfigOverride poolConfig = new NeoBufferPoolConfigOverride(null, buckets);
        this.bufferPool = new NeoByteBufferPool(poolConfig, this.memoryPools, this.jobScheduler);
        this.memoryPool = (MemoryPool)this.memoryPools.getPools().stream().filter(pool -> pool.group() == MemoryGroup.CENTRAL_BYTE_BUFFER_MANAGER).findFirst().get();
    }

    @Test
    void testNativeMemoryMonitoring() throws Exception {
        this.bufferPool.start();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler)).scheduleRecurring((Group)ArgumentMatchers.eq((Object)Group.BUFFER_POOL_MAINTENANCE), (JobMonitoringParams)ArgumentMatchers.any(), (Runnable)this.collectionRunnableCaptor.capture(), ArgumentMatchers.eq((long)20L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
        Runnable collectionRunnable = (Runnable)this.collectionRunnableCaptor.getValue();
        ByteBuffer b1 = this.bufferPool.acquire(1000);
        ByteBuffer b2 = this.bufferPool.acquire(1000);
        ByteBuffer b3 = this.bufferPool.acquire(1000);
        ByteBuffer b4 = this.bufferPool.acquire(2000);
        ByteBuffer b5 = this.bufferPool.acquire(4000);
        this.verifyMemory(ByteUnit.kibiBytes((long)9L), 0L);
        this.bufferPool.release(b2);
        this.bufferPool.release(b3);
        this.bufferPool.release(b5);
        collectionRunnable.run();
        collectionRunnable.run();
        this.verifyMemory(ByteUnit.kibiBytes((long)3L), 0L);
        ByteBuffer b6 = this.bufferPool.acquire(1000);
        this.verifyMemory(ByteUnit.kibiBytes((long)4L), 0L);
        this.bufferPool.release(b4);
        this.bufferPool.release(b6);
        this.bufferPool.stop();
        this.verifyMemory(ByteUnit.kibiBytes((long)1L), 0L);
    }

    @Test
    void testHeapMemoryMonitoring() throws Exception {
        this.bufferPool.start();
        this.bufferPool.getHeapBufferMemoryTracker().allocateHeap(ByteUnit.kibiBytes((long)1L));
        this.bufferPool.getHeapBufferMemoryTracker().allocateHeap(ByteUnit.kibiBytes((long)1L));
        this.bufferPool.getHeapBufferMemoryTracker().allocateHeap(ByteUnit.kibiBytes((long)1L));
        this.bufferPool.getHeapBufferMemoryTracker().allocateHeap(ByteUnit.kibiBytes((long)2L));
        this.bufferPool.getHeapBufferMemoryTracker().allocateHeap(ByteUnit.kibiBytes((long)4L));
        this.verifyMemory(0L, ByteUnit.kibiBytes((long)9L));
        this.bufferPool.getHeapBufferMemoryTracker().releaseHeap(ByteUnit.kibiBytes((long)1L));
        this.bufferPool.getHeapBufferMemoryTracker().releaseHeap(ByteUnit.kibiBytes((long)1L));
        this.bufferPool.getHeapBufferMemoryTracker().releaseHeap(ByteUnit.kibiBytes((long)4L));
        this.verifyMemory(0L, ByteUnit.kibiBytes((long)3L));
        this.bufferPool.getHeapBufferMemoryTracker().allocateHeap(ByteUnit.kibiBytes((long)1L));
        this.verifyMemory(0L, ByteUnit.kibiBytes((long)4L));
        this.bufferPool.getHeapBufferMemoryTracker().releaseHeap(ByteUnit.kibiBytes((long)1L));
        this.bufferPool.getHeapBufferMemoryTracker().releaseHeap(ByteUnit.kibiBytes((long)2L));
        this.bufferPool.stop();
        this.verifyMemory(0L, ByteUnit.kibiBytes((long)1L));
    }

    private void verifyMemory(long expectedNative, long expectedHeap) {
        Assertions.assertEquals((long)expectedNative, (long)this.memoryPool.usedNative());
        Assertions.assertEquals((long)expectedHeap, (long)this.memoryPool.usedHeap());
    }
}

