/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileVisitors;

class FileVisitorsDecoratorsTest {
    private final FileVisitor<Path> wrapped = (FileVisitor)Mockito.mock(FileVisitor.class);

    FileVisitorsDecoratorsTest() {
    }

    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"decorator", FileVisitors.Decorator::new, false}), Arguments.of((Object[])new Object[]{"onFile", wrapped -> FileVisitors.onFile((ThrowingConsumer)ThrowingConsumer.noop(), (FileVisitor)wrapped), false}), Arguments.of((Object[])new Object[]{"onDirectory", wrapped -> FileVisitors.onDirectory((ThrowingConsumer)ThrowingConsumer.noop(), (FileVisitor)wrapped), false}), Arguments.of((Object[])new Object[]{"throwExceptions", FileVisitors::throwExceptions, true}), Arguments.of((Object[])new Object[]{"onlyMatching", wrapped -> FileVisitors.onlyMatching((Predicate)Predicates.alwaysTrue(), (FileVisitor)wrapped), false}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldDelegatePreVisitDirectory(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Path dir = Paths.get("some-dir", new String[0]);
        BasicFileAttributes attrs = (BasicFileAttributes)Mockito.mock(BasicFileAttributes.class);
        decorator.preVisitDirectory(dir, attrs);
        ((FileVisitor)Mockito.verify(this.wrapped)).preVisitDirectory(dir, attrs);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateReturnValueFromPreVisitDirectory(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.preVisitDirectory((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenReturn((Object)result);
            Assertions.assertThat((Comparable)((Object)decorator.preVisitDirectory(null, null))).isEqualTo((Object)result);
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateExceptionsFromPreVisitDirectory(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Mockito.when((Object)((Object)this.wrapped.preVisitDirectory((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException("test")});
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> decorator.preVisitDirectory(null, null));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldDelegatePostVisitDirectory(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Path dir = Paths.get("some-dir", new String[0]);
        IOException e = throwsExceptions ? null : new IOException("test");
        decorator.postVisitDirectory(dir, e);
        ((FileVisitor)Mockito.verify(this.wrapped)).postVisitDirectory(dir, e);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateReturnValueFromPostVisitDirectory(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.postVisitDirectory((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenReturn((Object)result);
            Assertions.assertThat((Comparable)((Object)decorator.postVisitDirectory(null, null))).isEqualTo((Object)result);
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateExceptionsFromPostVisitDirectory(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Mockito.when((Object)((Object)this.wrapped.postVisitDirectory((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException("test")});
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> decorator.postVisitDirectory(null, null));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldDelegateVisitFile(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Path dir = Paths.get("some-dir", new String[0]);
        BasicFileAttributes attrs = (BasicFileAttributes)Mockito.mock(BasicFileAttributes.class);
        decorator.visitFile(dir, attrs);
        ((FileVisitor)Mockito.verify(this.wrapped)).visitFile(dir, attrs);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateReturnValueFromVisitFile(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.visitFile((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenReturn((Object)result);
            Assertions.assertThat((Comparable)((Object)decorator.visitFile(null, null))).isEqualTo((Object)result);
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateExceptionsFromVisitFile(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Mockito.when((Object)((Object)this.wrapped.visitFile((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException("test")});
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> decorator.visitFile(null, null));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldDelegateVisitFileFailed(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Path dir = Paths.get("some-dir", new String[0]);
        IOException e = throwsExceptions ? null : new IOException("test");
        decorator.visitFileFailed(dir, e);
        ((FileVisitor)Mockito.verify(this.wrapped)).visitFileFailed(dir, e);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateReturnValueFromVisitFileFailed(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        for (FileVisitResult result : FileVisitResult.values()) {
            Mockito.when((Object)((Object)this.wrapped.visitFileFailed((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenReturn((Object)result);
            Assertions.assertThat((Comparable)((Object)decorator.visitFileFailed(null, null))).isEqualTo((Object)result);
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void shouldPropagateExceptionsFromVisitFileFailed(String name, DecoratorCtor decoratorConstructor, boolean throwsExceptions) throws IOException {
        FileVisitor decorator = (FileVisitor)decoratorConstructor.apply(this.wrapped);
        Mockito.when((Object)((Object)this.wrapped.visitFileFailed((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new IOException("test")});
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> decorator.visitFileFailed(null, null));
    }

    static interface DecoratorCtor
    extends Function<FileVisitor<Path>, FileVisitor<Path>> {
    }
}

