/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.io.ByteUnit;

public class NeoBufferPoolConfigOverride {
    private final Duration collectionInterval;
    private final List<BucketConfig> buckets;

    public NeoBufferPoolConfigOverride(Duration collectionInterval, List<String> buckets) {
        this.collectionInterval = collectionInterval;
        this.buckets = buckets.stream().map(NeoBufferPoolConfigOverride::parseBucketExpression).collect(Collectors.toList());
    }

    private static BucketConfig parseBucketExpression(String bucketExpression) {
        String[] parts = bucketExpression.split(":");
        if (parts.length != 2) {
            throw NeoBufferPoolConfigOverride.incorrectFormatException(bucketExpression);
        }
        int bufferSize = (int)ByteUnit.parse(parts[0]);
        String sliceExpression = parts[1];
        if (sliceExpression.charAt(sliceExpression.length() - 1) == 'C') {
            String coefficientStr = sliceExpression.substring(0, sliceExpression.length() - 1);
            try {
                double coefficient = Double.parseDouble(coefficientStr);
                return new BucketConfig(bufferSize, coefficient);
            }
            catch (Exception e) {
                throw NeoBufferPoolConfigOverride.incorrectFormatException(bucketExpression);
            }
        }
        try {
            int sliceCount = Integer.parseInt(sliceExpression);
            return new BucketConfig(bufferSize, sliceCount);
        }
        catch (Exception e) {
            throw NeoBufferPoolConfigOverride.incorrectFormatException(bucketExpression);
        }
    }

    private static RuntimeException incorrectFormatException(String bucketExpression) {
        return new IllegalArgumentException("Incorrect format of bucket expression: " + bucketExpression);
    }

    public Duration getCollectionInterval() {
        return this.collectionInterval;
    }

    public List<BucketConfig> getBuckets() {
        return this.buckets;
    }

    static class BucketConfig {
        private final int bufferCapacity;
        private final Integer sliceCount;
        private final Double sliceCoefficient;

        BucketConfig(int bufferCapacity, int sliceCount) {
            this.bufferCapacity = bufferCapacity;
            this.sliceCoefficient = null;
            this.sliceCount = sliceCount;
        }

        BucketConfig(int bufferCapacity, double sliceCoefficient) {
            this.bufferCapacity = bufferCapacity;
            this.sliceCount = null;
            this.sliceCoefficient = sliceCoefficient;
        }

        int getBufferCapacity() {
            return this.bufferCapacity;
        }

        Integer getSliceCount() {
            return this.sliceCount;
        }

        Double getSliceCoefficient() {
            return this.sliceCoefficient;
        }
    }
}

