/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.cursor;

import java.io.IOException;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class DefaultPageCursorTracer
implements PageCursorTracer {
    private long pins;
    private long unpins;
    private long hits;
    private long faults;
    private long bytesRead;
    private long bytesWritten;
    private long evictions;
    private long evictionExceptions;
    private long flushes;
    private long merges;
    private final DefaultPinEvent pinTracingEvent = new DefaultPinEvent();
    private final PageCacheTracer pageCacheTracer;
    private final String tag;
    private final EvictionEvent evictionEvent = new EvictionEvent(){

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
        }

        @Override
        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            return DefaultPageCursorTracer.this.flushEvent;
        }

        @Override
        public void threwException(IOException exception) {
            ++DefaultPageCursorTracer.this.evictionExceptions;
        }

        @Override
        public void close() {
            ++DefaultPageCursorTracer.this.evictions;
        }
    };
    private final PageFaultEvent pageFaultEvent = new PageFaultEvent(){

        @Override
        public void addBytesRead(long bytes) {
            DefaultPageCursorTracer.this.bytesRead += bytes;
        }

        @Override
        public void done() {
            ++DefaultPageCursorTracer.this.faults;
        }

        @Override
        public void fail(Throwable throwable) {
            this.done();
        }

        @Override
        public void freeListSize(int listSize) {
        }

        @Override
        public EvictionEvent beginEviction(long cachePageId) {
            return DefaultPageCursorTracer.this.evictionEvent;
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }
    };
    private final FlushEvent flushEvent = new FlushEvent(){

        @Override
        public void addBytesWritten(long bytes) {
            DefaultPageCursorTracer.this.bytesWritten += bytes;
        }

        @Override
        public void done() {
        }

        @Override
        public void done(IOException exception) {
            this.done();
        }

        @Override
        public void addPagesFlushed(int pageCount) {
            DefaultPageCursorTracer.this.flushes += (long)pageCount;
        }

        @Override
        public void addPagesMerged(int pagesMerged) {
            DefaultPageCursorTracer.this.merges += (long)pagesMerged;
        }
    };

    public DefaultPageCursorTracer(PageCacheTracer pageCacheTracer, String tag) {
        this.pageCacheTracer = pageCacheTracer;
        this.tag = tag;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void reportEvents() {
        if (this.pins > 0L) {
            this.pageCacheTracer.pins(this.pins);
        }
        if (this.unpins > 0L) {
            this.pageCacheTracer.unpins(this.unpins);
        }
        if (this.hits > 0L) {
            this.pageCacheTracer.hits(this.hits);
        }
        if (this.faults > 0L) {
            this.pageCacheTracer.faults(this.faults);
        }
        if (this.bytesRead > 0L) {
            this.pageCacheTracer.bytesRead(this.bytesRead);
        }
        if (this.evictions > 0L) {
            this.pageCacheTracer.evictions(this.evictions);
        }
        if (this.evictionExceptions > 0L) {
            this.pageCacheTracer.evictionExceptions(this.evictionExceptions);
        }
        if (this.bytesWritten > 0L) {
            this.pageCacheTracer.bytesWritten(this.bytesWritten);
        }
        if (this.flushes > 0L) {
            this.pageCacheTracer.flushes(this.flushes);
        }
        if (this.merges > 0L) {
            this.pageCacheTracer.merges(this.merges);
        }
        this.reset();
    }

    private void reset() {
        this.pins = 0L;
        this.unpins = 0L;
        this.hits = 0L;
        this.faults = 0L;
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.evictions = 0L;
        this.evictionExceptions = 0L;
        this.flushes = 0L;
        this.merges = 0L;
    }

    @Override
    public long faults() {
        return this.faults;
    }

    @Override
    public long pins() {
        return this.pins;
    }

    @Override
    public long unpins() {
        return this.unpins;
    }

    @Override
    public long hits() {
        return this.hits;
    }

    @Override
    public long bytesRead() {
        return this.bytesRead;
    }

    @Override
    public long evictions() {
        return this.evictions;
    }

    @Override
    public long evictionExceptions() {
        return this.evictionExceptions;
    }

    @Override
    public long bytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long flushes() {
        return this.flushes;
    }

    @Override
    public long merges() {
        return this.merges;
    }

    @Override
    public double hitRatio() {
        return MathUtil.portion((double[])new double[]{this.hits(), this.faults()});
    }

    @Override
    public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
        ++this.pins;
        this.pinTracingEvent.eventHits = 1;
        return this.pinTracingEvent;
    }

    private class DefaultPinEvent
    implements PinEvent {
        private int eventHits = 1;

        private DefaultPinEvent() {
        }

        @Override
        public void setCachePageId(long cachePageId) {
        }

        @Override
        public PageFaultEvent beginPageFault(long filePageId, int swapperId) {
            this.eventHits = 0;
            return DefaultPageCursorTracer.this.pageFaultEvent;
        }

        @Override
        public void hit() {
            DefaultPageCursorTracer.this.hits += (long)this.eventHits;
        }

        @Override
        public void done() {
            ++DefaultPageCursorTracer.this.unpins;
        }
    }
}

