/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.neo4j.io.bufferpool.ByteBufferManger;
import org.neo4j.io.bufferpool.impl.Bucket;
import org.neo4j.io.bufferpool.impl.BucketBootstrapper;
import org.neo4j.io.bufferpool.impl.MemoryMonitor;
import org.neo4j.io.bufferpool.impl.NeoBufferPoolConfigOverride;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.VisibleForTesting;

public class NeoByteBufferPool
extends LifecycleAdapter
implements ByteBufferManger {
    private static final Duration DEFAULT_COLLECTION_INTERVAL = Duration.ofSeconds(20L);
    private final JobScheduler jobScheduler;
    private final Duration collectionInterval;
    private final Bucket[] buckets;
    private final MemoryMonitor memoryMonitor;
    private final int maxPooledBufferCapacity;
    private JobHandle<?> collectionJob;

    public NeoByteBufferPool(NeoBufferPoolConfigOverride configOverride, MemoryPools memoryPools, JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.memoryMonitor = this.crateMemoryMonitor(memoryPools);
        this.collectionInterval = configOverride.getCollectionInterval() == null ? DEFAULT_COLLECTION_INTERVAL : configOverride.getCollectionInterval();
        BucketBootstrapper bucketBootstrapper = new BucketBootstrapper(configOverride, this.memoryMonitor.getMemoryTracker());
        this.buckets = bucketBootstrapper.getBuckets().toArray(new Bucket[0]);
        this.maxPooledBufferCapacity = bucketBootstrapper.getMaxPooledBufferCapacity();
    }

    @VisibleForTesting
    MemoryMonitor crateMemoryMonitor(MemoryPools memoryPools) {
        return new MemoryMonitor(memoryPools);
    }

    public void start() throws Exception {
        this.collectionJob = this.jobScheduler.scheduleRecurring(Group.BUFFER_POOL_MAINTENANCE, JobMonitoringParams.systemJob((String)"Buffer pool maintenance"), () -> Arrays.stream(this.buckets).forEach(Bucket::prunePooledBuffers), this.collectionInterval.toSeconds(), TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
        if (this.collectionJob != null) {
            this.collectionJob.cancel();
            try {
                this.collectionJob.waitTermination();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Arrays.stream(this.buckets).forEach(Bucket::releasePooledBuffers);
    }

    @Override
    public ByteBuffer acquire(int size) {
        if (size > this.maxPooledBufferCapacity) {
            return ByteBuffers.allocateDirect(size, this.memoryMonitor.getMemoryTracker());
        }
        Bucket bucket = this.getBucketFor(size);
        ByteBuffer buffer = bucket.acquire();
        return buffer.clear().limit(size);
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw NeoByteBufferPool.alienBufferException(buffer);
        }
        if (buffer.capacity() > this.maxPooledBufferCapacity) {
            ByteBuffers.releaseBuffer(buffer, this.memoryMonitor.getMemoryTracker());
            return;
        }
        Bucket bucket = this.getBucketFor(buffer.capacity());
        if (buffer.capacity() != bucket.getBufferCapacity()) {
            throw NeoByteBufferPool.alienBufferException(buffer);
        }
        bucket.release(buffer);
    }

    @Override
    public int recommendNewCapacity(int minNewCapacity, int maxCapacity) {
        if (minNewCapacity > this.maxPooledBufferCapacity) {
            return -1;
        }
        return Math.min(this.getBucketFor(minNewCapacity).getBufferCapacity(), maxCapacity);
    }

    @Override
    public MemoryTracker getHeapBufferMemoryTracker() {
        return this.memoryMonitor.getMemoryTracker();
    }

    private Bucket getBucketFor(int size) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Bucket pool = this.buckets[i];
            if (pool.getBufferCapacity() < size) continue;
            return pool;
        }
        throw new IllegalStateException("There is no bucket big enough to allocate " + size + " bytes");
    }

    private static RuntimeException alienBufferException(ByteBuffer buffer) {
        return new IllegalArgumentException("Trying to release a buffer not acquired from this buffer manager: " + buffer);
    }
}

