/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;

class WrappingFileHandle
implements FileHandle {
    private final Path file;
    private final Path baseDirectory;
    private final FileSystemAbstraction fs;

    WrappingFileHandle(Path file, Path baseDirectory, FileSystemAbstraction fs) {
        this.file = file;
        this.baseDirectory = baseDirectory;
        this.fs = fs;
    }

    @Override
    public Path getPath() {
        return this.file;
    }

    @Override
    public Path getRelativePath() {
        return this.baseDirectory.relativize(this.file);
    }

    @Override
    public void rename(Path to, CopyOption ... options) throws IOException {
        Path parentFile = this.file.getParent();
        Path canonicalTarget = to.normalize();
        this.fs.mkdirs(canonicalTarget.getParent());
        this.fs.renameFile(this.file, canonicalTarget, options);
        this.removeEmptyParent(parentFile);
    }

    private void removeEmptyParent(Path parentFile) throws IOException {
        Path end = this.baseDirectory.getParent();
        while (parentFile != null && !parentFile.equals(end)) {
            Path[] files = this.fs.listFiles(parentFile);
            if (files.length > 0) {
                return;
            }
            this.fs.deleteFile(parentFile);
            parentFile = parentFile.getParent();
        }
    }

    @Override
    public void delete() throws IOException {
        Path parent = this.file.getParent();
        this.fs.deleteFileOrThrow(this.file);
        this.removeEmptyParent(parent);
    }
}

