/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileVisitors;

class OnFileTest {
    private final ThrowingConsumer<Path, IOException> operation = (ThrowingConsumer)Mockito.mock(ThrowingConsumer.class);
    private final FileVisitor<Path> wrapped = (FileVisitor)Mockito.mock(FileVisitor.class);

    OnFileTest() {
    }

    @Test
    void shouldNotOperateOnDirectories() throws IOException {
        Path dir = Paths.get("/some/path", new String[0]);
        FileVisitors.onFile(this.operation, this.wrapped).preVisitDirectory(dir, null);
        ((ThrowingConsumer)Mockito.verify(this.operation, (VerificationMode)Mockito.never())).accept((Object)dir);
    }

    @Test
    void shouldOperateOnFiles() throws IOException {
        Path file = Paths.get("/some/path", new String[0]);
        FileVisitors.onFile(this.operation, this.wrapped).visitFile(file, null);
        ((ThrowingConsumer)Mockito.verify(this.operation)).accept((Object)file);
    }
}

