/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.neo4j.io.fs.ChecksumWriter;
import org.neo4j.io.fs.FlushableChecksumChannel;
import org.neo4j.io.fs.PhysicalFlushableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.util.FeatureToggles;

public class PhysicalFlushableChecksumChannel
extends PhysicalFlushableChannel
implements FlushableChecksumChannel {
    static final boolean DISABLE_WAL_CHECKSUM = FeatureToggles.flag(ChecksumWriter.class, (String)"disableChecksum", (boolean)false);
    private final ByteBuffer checksumView;
    private final Checksum checksum;

    public PhysicalFlushableChecksumChannel(StoreChannel channel, ScopedBuffer scopedBuffer) {
        super(channel, scopedBuffer);
        this.checksumView = scopedBuffer.getBuffer().duplicate();
        this.checksum = (Checksum)CHECKSUM_FACTORY.get();
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        if (!DISABLE_WAL_CHECKSUM) {
            this.checksumView.limit(this.buffer.position());
            this.checksum.update(this.checksumView);
            this.checksumView.clear();
        }
        return super.prepareForFlush();
    }

    @Override
    public int putChecksum() throws IOException {
        this.bufferWithGuaranteedSpace(4);
        if (DISABLE_WAL_CHECKSUM) {
            this.buffer.putInt(-559063315);
            return -559063315;
        }
        this.checksumView.limit(this.buffer.position());
        this.checksum.update(this.checksumView);
        int checksum = (int)this.checksum.getValue();
        this.buffer.putInt(checksum);
        return checksum;
    }

    @Override
    public void beginChecksum() {
        if (DISABLE_WAL_CHECKSUM) {
            return;
        }
        this.checksum.reset();
        this.checksumView.limit(this.checksumView.capacity());
        this.checksumView.position(this.buffer.position());
    }

    @Override
    public FlushableChecksumChannel put(byte value) throws IOException {
        return (FlushableChecksumChannel)super.put(value);
    }

    @Override
    public FlushableChecksumChannel putShort(short value) throws IOException {
        return (FlushableChecksumChannel)super.putShort(value);
    }

    @Override
    public FlushableChecksumChannel putInt(int value) throws IOException {
        return (FlushableChecksumChannel)super.putInt(value);
    }

    @Override
    public FlushableChecksumChannel putLong(long value) throws IOException {
        return (FlushableChecksumChannel)super.putLong(value);
    }

    @Override
    public FlushableChecksumChannel putFloat(float value) throws IOException {
        return (FlushableChecksumChannel)super.putFloat(value);
    }

    @Override
    public FlushableChecksumChannel putDouble(double value) throws IOException {
        return (FlushableChecksumChannel)super.putDouble(value);
    }

    @Override
    public FlushableChecksumChannel put(byte[] value, int offset, int length) throws IOException {
        return (FlushableChecksumChannel)super.put(value, offset, length);
    }
}

