/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, PageCacheTracer cacheTracer) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fileSystem, cacheTracer);
        int pageSize = 8192;
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler, cacheTracer, pageSize);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        int pageSize = 8192;
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fileSystem, cacheTracer);
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler, cacheTracer, pageSize);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, int pageSize) {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fileSystem, cacheTracer);
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler, cacheTracer, pageSize);
    }

    private static PageCache createPageCache(PageSwapperFactory factory, JobScheduler jobScheduler, PageCacheTracer cacheTracer, int pageSize) {
        long expectedMemory = Math.max(ByteUnit.MebiByte.toBytes(8L), 10L * (long)pageSize);
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator(expectedMemory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return new MuninnPageCache(factory, jobScheduler, MuninnPageCache.config(memoryAllocator).pageCacheTracer(cacheTracer).pageSize(pageSize));
    }
}

