/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.concurrent.Futures;

class ByteBufferFactoryTest {
    ByteBufferFactoryTest() {
    }

    @Test
    void shouldCloseGlobalAllocationsOnClose() {
        ByteBufferFactory.Allocator allocator = (ByteBufferFactory.Allocator)Mockito.mock(ByteBufferFactory.Allocator.class);
        Mockito.when((Object)allocator.allocate(ArgumentMatchers.anyInt(), (MemoryTracker)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new HeapScopedBuffer(((Integer)invocationOnMock.getArgument(0)).intValue(), (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        ByteBufferFactory factory = new ByteBufferFactory(() -> allocator, 100);
        factory.acquireThreadLocalBuffer((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        factory.releaseThreadLocalBuffer();
        factory.acquireThreadLocalBuffer((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        factory.releaseThreadLocalBuffer();
        factory.globalAllocator().allocate(123, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        factory.globalAllocator().allocate(456, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        factory.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{allocator});
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).allocate(100, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).allocate(123, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).allocate(456, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((ByteBufferFactory.Allocator)inOrder.verify((Object)allocator, Mockito.times((int)1))).close();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldCreateNewInstancesOfLocalAllocators() {
        Supplier<ByteBufferFactory.Allocator> allocator = () -> (ByteBufferFactory.Allocator)Mockito.mock(ByteBufferFactory.Allocator.class);
        ByteBufferFactory factory = new ByteBufferFactory(allocator, 100);
        ByteBufferFactory.Allocator localAllocator1 = factory.newLocalAllocator();
        ByteBufferFactory.Allocator localAllocator2 = factory.newLocalAllocator();
        localAllocator2.close();
        ByteBufferFactory.Allocator localAllocator3 = factory.newLocalAllocator();
        Assertions.assertNotSame((Object)localAllocator1, (Object)localAllocator2);
        Assertions.assertNotSame((Object)localAllocator2, (Object)localAllocator3);
        Assertions.assertNotSame((Object)localAllocator1, (Object)localAllocator3);
    }

    @Test
    void shouldFailAcquireThreadLocalBufferIfAlreadyAcquired() {
        ByteBufferFactory factory = ByteBufferFactory.heapBufferFactory((int)1024);
        factory.acquireThreadLocalBuffer((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThrows(IllegalStateException.class, () -> factory.acquireThreadLocalBuffer((MemoryTracker)EmptyMemoryTracker.INSTANCE));
        factory.close();
    }

    @Test
    void shouldFailReleaseThreadLocalBufferIfNotAcquired() {
        ByteBufferFactory factory = ByteBufferFactory.heapBufferFactory((int)1024);
        factory.acquireThreadLocalBuffer((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        factory.releaseThreadLocalBuffer();
        Assertions.assertThrows(IllegalStateException.class, () -> ((ByteBufferFactory)factory).releaseThreadLocalBuffer());
        factory.close();
    }

    @Test
    void shouldShareThreadLocalBuffersLoggingIndexedIdGeneratorMonitorStressfully() throws Throwable {
        int i;
        ByteBufferFactory factory = ByteBufferFactory.heapBufferFactory((int)1024);
        int threads = 10;
        CountDownLatch startLatch = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        ArrayList seenBuffers = new ArrayList();
        for (i = 0; i < threads; ++i) {
            HashSet seen = new HashSet();
            seenBuffers.add(seen);
            futures.add(executor.submit(() -> {
                startLatch.await();
                for (int j = 0; j < 1000; ++j) {
                    ByteBuffer buffer = factory.acquireThreadLocalBuffer((MemoryTracker)EmptyMemoryTracker.INSTANCE);
                    Assertions.assertNotNull((Object)buffer);
                    seen.add(buffer);
                    factory.releaseThreadLocalBuffer();
                }
                return null;
            }));
        }
        startLatch.countDown();
        Futures.getAll(futures);
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.SECONDS);
        for (i = 0; i < threads; ++i) {
            Assertions.assertEquals((int)1, (int)((Set)seenBuffers.get(i)).size());
        }
        factory.close();
    }

    @Disabled
    void releaseAllBuffersReleaseMemoryFromThreadLocalBuffers() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        ByteBufferFactory factory = ByteBufferFactory.heapBufferFactory((int)10);
        factory.acquireThreadLocalBuffer((MemoryTracker)memoryTracker);
        factory.releaseThreadLocalBuffer();
        factory.acquireThreadLocalBuffer((MemoryTracker)memoryTracker);
        factory.releaseThreadLocalBuffer();
        factory.acquireThreadLocalBuffer((MemoryTracker)memoryTracker);
        factory.releaseThreadLocalBuffer();
        Assertions.assertEquals((long)10L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void byteBufferMustThrowOutOfBoundsAfterRelease() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)8, (MemoryTracker)tracker);
        buffer.get(0);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void doubleFreeOfByteBufferIsOkay() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)8, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }
}

