/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.WritableChannel;

public class OutputStreamWritableChannel
implements FlushableChannel {
    private final DataOutputStream dataOutputStream;
    private boolean isClosed;

    public OutputStreamWritableChannel(OutputStream outputStream) {
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        return this.dataOutputStream;
    }

    @Override
    public OutputStreamWritableChannel put(byte value) throws IOException {
        this.dataOutputStream.writeByte(value);
        return this;
    }

    @Override
    public OutputStreamWritableChannel putShort(short value) throws IOException {
        this.dataOutputStream.writeShort(value);
        return this;
    }

    @Override
    public OutputStreamWritableChannel putInt(int value) throws IOException {
        this.dataOutputStream.writeInt(value);
        return this;
    }

    @Override
    public OutputStreamWritableChannel putLong(long value) throws IOException {
        this.dataOutputStream.writeLong(value);
        return this;
    }

    @Override
    public OutputStreamWritableChannel putFloat(float value) throws IOException {
        this.dataOutputStream.writeFloat(value);
        return this;
    }

    @Override
    public OutputStreamWritableChannel putDouble(double value) throws IOException {
        this.dataOutputStream.writeDouble(value);
        return this;
    }

    @Override
    public OutputStreamWritableChannel put(byte[] value, int length) throws IOException {
        this.dataOutputStream.write(value, 0, length);
        return this;
    }

    @Override
    public OutputStreamWritableChannel put(byte[] value, int offset, int length) throws IOException {
        this.dataOutputStream.write(value, offset, length);
        return this;
    }

    @Override
    public OutputStreamWritableChannel putAll(ByteBuffer src) throws IOException {
        if (src.hasArray()) {
            this.dataOutputStream.write(src.array(), src.position(), src.remaining());
        } else {
            while (src.hasRemaining()) {
                this.dataOutputStream.writeByte(src.get());
            }
        }
        return this;
    }

    @Override
    public WritableChannel putVersion(byte version) throws IOException {
        return this.put(version);
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.dataOutputStream.close();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        this.putAll(src);
        return remaining;
    }

    @Override
    public void beginChecksumForWriting() {
    }

    @Override
    public int putChecksum() throws IOException {
        return 0;
    }
}

