/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.monitoring.PageFileCounters;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.version.FileTruncateEvent;

public class ByteArrayPageCursor
extends PageCursor {
    private static final long DEFAULT_PAGE_ID = 0L;
    private final MutableLongObjectMap<ByteBuffer> buffers;
    private long pageId;
    private boolean initialized;
    private ByteBuffer buffer;
    private CursorException cursorException;

    public static PageCursor wrap(byte[] array, int offset, int length, long currentPageId) {
        return new ByteArrayPageCursor(currentPageId, ByteBuffer.wrap(array, offset, length).order(ByteOrder.LITTLE_ENDIAN));
    }

    public static PageCursor wrap(byte[] array, int offset, int length) {
        return ByteArrayPageCursor.wrap(array, offset, length, 0L);
    }

    public static PageCursor wrap(byte[] array) {
        return ByteArrayPageCursor.wrap(array, 0, array.length);
    }

    public static PageCursor wrap(int length) {
        return ByteArrayPageCursor.wrap(new byte[length]);
    }

    public ByteArrayPageCursor(ByteBuffer buffer) {
        this(0L, buffer);
    }

    public ByteArrayPageCursor(long pageId, ByteBuffer buffer) {
        this.buffers = LongObjectMaps.mutable.empty();
        this.buffers.put(pageId, (Object)buffer);
        this.pageId = pageId;
        this.buffer = buffer;
        this.initialized = true;
    }

    public ByteArrayPageCursor(MutableLongObjectMap<ByteBuffer> buffers, long pageId) {
        this.buffers = buffers;
        this.pageId = pageId;
        this.initialized = false;
        this.buffer = (ByteBuffer)buffers.get(pageId);
    }

    @Override
    public byte getByte() {
        return this.buffer.get();
    }

    @Override
    public byte getByte(int offset) {
        return this.buffer.get(offset);
    }

    @Override
    public void putByte(byte value) {
        this.buffer.put(value);
    }

    @Override
    public void putByte(int offset, byte value) {
        this.buffer.put(offset, value);
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public long getLong(int offset) {
        return this.buffer.getLong(offset);
    }

    @Override
    public void putLong(long value) {
        this.buffer.putLong(value);
    }

    @Override
    public void putLong(int offset, long value) {
        this.buffer.putLong(offset, value);
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public int getInt(int offset) {
        return this.buffer.getInt(offset);
    }

    @Override
    public void putInt(int value) {
        this.buffer.putInt(value);
    }

    @Override
    public void putInt(int offset, int value) {
        this.buffer.putInt(offset, value);
    }

    @Override
    public void getBytes(byte[] data) {
        this.buffer.get(data);
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.buffer.get(data, arrayOffset, length);
    }

    @Override
    public void putBytes(byte[] data) {
        this.buffer.put(data);
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        this.buffer.put(data, arrayOffset, length);
    }

    @Override
    public void putBytes(int bytes, byte value) {
        byte[] byteArray = new byte[bytes];
        Arrays.fill(byteArray, value);
        this.buffer.put(byteArray);
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public short getShort(int offset) {
        return this.buffer.getShort(offset);
    }

    @Override
    public void putShort(short value) {
        this.buffer.putShort(value);
    }

    @Override
    public void putShort(int offset, short value) {
        this.buffer.putShort(offset, value);
    }

    @Override
    public void setOffset(int offset) {
        this.buffer.position(offset);
    }

    @Override
    public int getOffset() {
        return this.buffer.position();
    }

    @Override
    public void mark() {
        this.buffer.mark();
    }

    @Override
    public void setOffsetToMark() {
        this.buffer.reset();
    }

    @Override
    public long getCurrentPageId() {
        return this.pageId;
    }

    @Override
    public Path getCurrentFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PagedFile getPagedFile() {
        return new ByteArrayPagedFile(this.buffer.capacity());
    }

    @Override
    public Path getRawCurrentFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() {
        if (!this.initialized) {
            this.initialized = true;
            return true;
        }
        return this.next(this.pageId + 1L);
    }

    @Override
    public boolean next(long pageId) {
        this.initialized = true;
        this.pageId = pageId;
        if (this.buffers.containsKey(pageId)) {
            this.buffer = (ByteBuffer)this.buffers.get(pageId);
        } else {
            this.buffer = ByteBuffer.allocate(this.buffer.capacity());
            this.buffers.put(pageId, (Object)this.buffer);
        }
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }

    @Override
    public void copyPage(PageCursor target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int copyTo(int sourceOffset, ByteBuffer targetBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int copyFrom(ByteBuffer sourceBuffer, int targetOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shiftBytes(int sourceOffset, int length, int shift) {
        int currentOffset = this.getOffset();
        this.setOffset(sourceOffset);
        byte[] bytes = new byte[length];
        this.getBytes(bytes);
        this.setOffset(sourceOffset + shift);
        this.putBytes(bytes);
        this.setOffset(currentOffset);
    }

    @Override
    public boolean checkAndClearBoundsFlag() {
        return false;
    }

    @Override
    public void checkAndClearCursorException() throws CursorException {
        if (this.cursorException != null) {
            try {
                throw this.cursorException;
            }
            catch (Throwable throwable) {
                this.cursorException = null;
                throw throwable;
            }
        }
    }

    @Override
    public void setCursorException(String message) {
        this.cursorException = (CursorException)Exceptions.chain((Throwable)this.cursorException, (Throwable)new CursorException(message));
    }

    @Override
    public void clearCursorException() {
    }

    @Override
    public PageCursor openLinkedCursor(long pageId) {
        if (!this.buffers.containsKey(pageId)) {
            this.buffers.put(pageId, (Object)ByteBuffer.allocate(this.buffer.capacity()));
        }
        return new ByteArrayPageCursor(this.buffers, pageId);
    }

    @Override
    public void zapPage() {
        Arrays.fill(this.buffer.array(), (byte)0);
    }

    @Override
    public boolean isWriteLocked() {
        return true;
    }

    @Override
    public void setPageHorizon(long horizon) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unpin() {
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    private record ByteArrayPagedFile(int pageSize) implements PagedFile
    {
        @Override
        public PageCursor io(long pageId, int pf_flags, CursorContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int payloadSize() {
            return this.pageSize;
        }

        @Override
        public int pageReservedBytes() {
            return 0;
        }

        @Override
        public long fileSize() {
            return this.pageSize;
        }

        @Override
        public Path path() {
            return null;
        }

        @Override
        public void flushAndForce(FileFlushEvent flushEvent) {
        }

        @Override
        public long getLastPageId() {
            return 0L;
        }

        @Override
        public void increaseLastPageIdTo(long newLastPageId) {
        }

        @Override
        public void close() {
        }

        @Override
        public void setDeleteOnClose(boolean deleteOnClose) {
        }

        @Override
        public boolean isDeleteOnClose() {
            return false;
        }

        @Override
        public String getDatabaseName() {
            return null;
        }

        @Override
        public PageFileCounters pageFileCounters() {
            return PageFileSwapperTracer.NULL;
        }

        @Override
        public boolean isMultiVersioned() {
            return false;
        }

        @Override
        public void truncate(long pagesToKeep, FileTruncateEvent truncateEvent) {
        }

        @Override
        public int touch(long pageId, int count, CursorContext cursorContext) {
            return 0;
        }

        @Override
        public boolean preAllocateSupported() {
            return false;
        }

        @Override
        public void preAllocate(long newFileSizeInPages) {
        }
    }
}

