/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.neo4j.io.fs.ReadableChannel;

public class InputStreamReadableChannel
implements ReadableChannel {
    private final DataInputStream dataInputStream;

    public InputStreamReadableChannel(InputStream inputStream) {
        this.dataInputStream = new DataInputStream(inputStream);
    }

    @Override
    public byte get() throws IOException {
        return this.dataInputStream.readByte();
    }

    @Override
    public short getShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    @Override
    public int getInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    @Override
    public long getLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    @Override
    public float getFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    @Override
    public double getDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws IOException {
        this.dataInputStream.read(bytes, 0, length);
    }

    @Override
    public void close() throws IOException {
        this.dataInputStream.close();
    }
}

