/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.AutoCloseablePageCacheTracerEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;

public class DatabaseFlushEvent
implements AutoCloseablePageCacheTracerEvent {
    public static final DatabaseFlushEvent NULL = new DatabaseFlushEvent(FileFlushEvent.NULL){};
    private long pagesFlushed;
    private long ioPerformed;
    private long ioLimit;
    private long timesLimited;
    private long millisLimited;
    private final FileFlushEvent flushEvent;

    public DatabaseFlushEvent(FileFlushEvent flushEvent) {
        this.flushEvent = flushEvent;
    }

    public void reset() {
        this.pagesFlushed = 0L;
        this.ioPerformed = 0L;
        this.timesLimited = 0L;
        this.millisLimited = 0L;
        this.ioLimit = 0L;
        this.flushEvent.reset();
    }

    @Override
    public void close() {
        this.pagesFlushed += this.flushEvent.pagesFlushed();
        this.ioPerformed += this.flushEvent.ioPerformed();
        this.timesLimited += this.flushEvent.limitedNumberOfTimes();
        this.millisLimited += this.flushEvent.limitedMillis();
    }

    public FileFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.flushEvent;
    }

    public FileFlushEvent beginFileFlush() {
        return this.flushEvent;
    }

    public long pagesFlushed() {
        return this.pagesFlushed;
    }

    public long ioPerformed() {
        return this.ioPerformed;
    }

    public long getIoLimit() {
        return this.ioLimit;
    }

    public long getTimesLimited() {
        return this.timesLimited;
    }

    public long getMillisLimited() {
        return this.millisLimited;
    }

    public void ioControllerLimit(long configuredLimit) {
        this.ioLimit = configuredLimit;
    }
}

