/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.marshal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.InputStreamReadableChannel;
import org.neo4j.io.fs.OutputStreamWritableChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.marshal.LimitedStringChannelMarshal;

class LimitedStringChannelMarshalTest {
    LimitedStringChannelMarshalTest() {
    }

    @Test
    void shouldNotTruncateInputStringIfItFitsInMaxSize() throws IOException {
        LimitedStringChannelMarshal stringChannelMarshal = new LimitedStringChannelMarshal(10);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        String inputString = "ab";
        stringChannelMarshal.marshal(inputString, (WritableChannel)writableChannel);
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        String unmarshalledString = stringChannelMarshal.unmarshal((ReadableChannel)readableChannel);
        Assertions.assertThat((String)inputString).isEqualTo(unmarshalledString);
    }

    @Test
    void shouldTruncateInputStringIfItNotFitsInMaxSize() throws IOException {
        LimitedStringChannelMarshal stringChannelMarshal = new LimitedStringChannelMarshal(2);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        String inputString = "abc";
        stringChannelMarshal.marshal(inputString, (WritableChannel)writableChannel);
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        String unmarshalledString = stringChannelMarshal.unmarshal((ReadableChannel)readableChannel);
        Assertions.assertThat((String)"ab").isEqualTo(unmarshalledString);
    }

    @Test
    void ifWritableChanelExceedMaxSizeThenItShouldBeTruncated() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWritableChannel writableChannel = new OutputStreamWritableChannel((OutputStream)outputStream);
        writableChannel.putInt(3);
        writableChannel.put("abc".getBytes(StandardCharsets.UTF_8), 3);
        InputStreamReadableChannel readableChannel = new InputStreamReadableChannel((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
        String unmarshalledString = new LimitedStringChannelMarshal(2).unmarshal((ReadableChannel)readableChannel);
        Assertions.assertThat((String)unmarshalledString).isEqualTo("ab");
    }
}

