/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.context;

import java.util.function.LongSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class CursorContextFactory {
    public static final CursorContextFactory NULL_CONTEXT_FACTORY = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);
    private final PageCacheTracer cacheTracer;
    private final VersionContextSupplier versionContextSupplier;

    public CursorContextFactory(PageCacheTracer cacheTracer, VersionContextSupplier versionContextSupplier) {
        this.cacheTracer = cacheTracer;
        this.versionContextSupplier = versionContextSupplier;
    }

    public CursorContext create(String tag) {
        return new CursorContext(this, this.cacheTracer.createPageCursorTracer(tag), this.versionContextSupplier.createVersionContext());
    }

    public CursorContext create(String tag, VersionContext versionContext) {
        return new CursorContext(this, this.cacheTracer.createPageCursorTracer(tag), versionContext);
    }

    public CursorContext create(PageCursorTracer cursorTracer) {
        return new CursorContext(this, cursorTracer, this.versionContextSupplier.createVersionContext());
    }

    public void init(LongSupplier lastClosedTransactionIdSupplier) {
        this.versionContextSupplier.init(lastClosedTransactionIdSupplier);
    }
}

