/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.BlockSwapper;
import org.neo4j.io.pagecache.impl.FallbackBlockSwapper;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapper;
import org.neo4j.io.pagecache.impl.UnsafeBlockSwapper;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class SingleFilePageSwapperFactory
implements PageSwapperFactory {
    private final FileSystemAbstraction fs;
    private final PageCacheTracer pageCacheTracer;
    private final BlockSwapper blockSwapper;

    public SingleFilePageSwapperFactory(FileSystemAbstraction fs, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.fs = fs;
        this.pageCacheTracer = pageCacheTracer;
        this.blockSwapper = SingleFilePageSwapperFactory.createBlockSwapper(memoryTracker);
    }

    @Override
    public PageSwapper createPageSwapper(Path file, int filePageSize, int reservedPageBytes, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, boolean checksumPages, IOController ioController, SwapperSet swappers) throws IOException {
        if (!createIfNotExist && !this.fs.fileExists(file)) {
            throw new NoSuchFileException(file.toString(), null, "Cannot map non-existing file");
        }
        return new SingleFilePageSwapper(file, this.fs, filePageSize, reservedPageBytes, onEviction, useDirectIO, checksumPages, ioController, swappers, this.pageCacheTracer.createFileSwapperTracer(), this.blockSwapper, this.nativeAccess());
    }

    private static BlockSwapper createBlockSwapper(MemoryTracker memoryTracker) {
        if (UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            return new UnsafeBlockSwapper();
        }
        return new FallbackBlockSwapper(memoryTracker);
    }

    @VisibleForTesting
    protected NativeAccess nativeAccess() {
        return NativeAccessProvider.getNativeAccess();
    }
}

