/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.tracing.PinEvent;

final class MuninnReadPageCursor
extends MuninnPageCursor {
    long lockStamp;

    MuninnReadPageCursor(MuninnPagedFile pagedFile, int pf_flags, long victimPage, CursorContext cursorContext, long pageId) {
        super(pagedFile, pf_flags, victimPage, cursorContext, pageId);
    }

    @Override
    public void unpin() {
        if (this.pinnedPageRef != 0L) {
            this.tracer.unpin(this.loadPlainCurrentPageId(), this.swapper);
        }
        this.unmapSnapshot();
        this.lockStamp = 0L;
        this.clearPageCursorState();
        this.storeCurrentPageId(-1L);
    }

    @Override
    public boolean next() throws IOException {
        this.unpin();
        long lastPageId = this.assertCursorOpenFileMappedAndGetIdOfLastPage();
        if (this.nextPageId > lastPageId || this.nextPageId < 0L) {
            this.storeCurrentPageId(-1L);
            return false;
        }
        this.storeCurrentPageId(this.nextPageId);
        ++this.nextPageId;
        long filePageId = this.loadPlainCurrentPageId();
        try (PinEvent pinEvent = this.tracer.beginPin(false, filePageId, this.swapper);){
            this.pin(pinEvent, filePageId);
        }
        this.verifyContext();
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        this.lockStamp = PageList.tryOptimisticReadLock(pageRef);
        return true;
    }

    @Override
    protected void unlockPage(long pageRef) {
    }

    @Override
    protected void pinCursorToPage(PinEvent pinEvent, long pageRef, long filePageId, PageSwapper swapper) {
        this.init(pinEvent, pageRef);
        if (this.multiVersioned && this.shouldLoadSnapshot()) {
            this.versionStorage.loadReadSnapshot(this, this.versionContext, pinEvent);
        }
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        this.lockStamp = PageList.unlockExclusive(pageRef);
    }

    @Override
    public void remapSnapshot(MuninnPageCursor cursor, long committingTransactionId) {
        super.remapSnapshot(cursor, committingTransactionId);
        this.lockStamp = cursor.lockStamp();
    }

    @Override
    protected void restoreState(MuninnPageCursor.VersionState remappedState) {
        super.restoreState(remappedState);
        this.lockStamp = remappedState.lockStamp();
    }

    @Override
    public boolean shouldRetry() throws IOException {
        MuninnReadPageCursor cursor = this;
        do {
            long pageRef;
            if ((pageRef = cursor.pinnedPageRef) == 0L || PageList.validateReadLock(pageRef, cursor.lockStamp)) continue;
            this.assertCursorOpenFileMappedAndGetIdOfLastPage();
            this.startRetryLinkedChain();
            return true;
        } while ((cursor = (MuninnReadPageCursor)cursor.linkedCursor) != null);
        return false;
    }

    private void startRetryLinkedChain() throws IOException {
        MuninnReadPageCursor cursor = this;
        do {
            cursor.unmapSnapshot();
            long pageRef = cursor.pinnedPageRef;
            if (pageRef == 0L) continue;
            cursor.startRetry(pageRef);
        } while ((cursor = (MuninnReadPageCursor)cursor.linkedCursor) != null);
    }

    private void startRetry(long pageRef) throws IOException {
        this.setOffset(0);
        this.checkAndClearBoundsFlag();
        this.clearCursorException();
        this.lockStamp = PageList.tryOptimisticReadLock(pageRef);
        long filePageId = this.loadPlainCurrentPageId();
        if (!PageList.isBoundTo(pageRef, this.swapperId, filePageId) || this.multiVersioned) {
            this.clearPageReference();
            this.tracer.unpin(filePageId, this.swapper);
            try (PinEvent pinEvent = this.tracer.beginPin(false, filePageId, this.swapper);){
                this.pin(pinEvent, filePageId);
            }
        }
    }

    @Override
    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putLong(long value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putInt(int value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putShort(short value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void shiftBytes(int sourceStart, int length, int shift) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    long lockStamp() {
        return this.lockStamp;
    }

    @Override
    public void zapPage() {
        throw new IllegalStateException("Cannot write to read-locked page");
    }
}

