/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FlushableChannel;

public class OutputStreamWritableChannel
implements FlushableChannel {
    private final DataOutputStream dataOutputStream;

    public OutputStreamWritableChannel(OutputStream outputStream) {
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        return this.dataOutputStream;
    }

    @Override
    public FlushableChannel put(byte value) throws IOException {
        this.dataOutputStream.writeByte(value);
        return this;
    }

    @Override
    public FlushableChannel putShort(short value) throws IOException {
        this.dataOutputStream.writeShort(value);
        return this;
    }

    @Override
    public FlushableChannel putInt(int value) throws IOException {
        this.dataOutputStream.writeInt(value);
        return this;
    }

    @Override
    public FlushableChannel putLong(long value) throws IOException {
        this.dataOutputStream.writeLong(value);
        return this;
    }

    @Override
    public FlushableChannel putFloat(float value) throws IOException {
        this.dataOutputStream.writeFloat(value);
        return this;
    }

    @Override
    public FlushableChannel putDouble(double value) throws IOException {
        this.dataOutputStream.writeDouble(value);
        return this;
    }

    @Override
    public FlushableChannel put(byte[] value, int length) throws IOException {
        this.dataOutputStream.write(value, 0, length);
        return this;
    }

    @Override
    public FlushableChannel put(byte[] value, int offset, int length) throws IOException {
        this.dataOutputStream.write(value, offset, length);
        return this;
    }

    @Override
    public FlushableChannel putAll(ByteBuffer src) throws IOException {
        if (src.hasArray()) {
            this.dataOutputStream.write(src.array());
        } else {
            while (src.hasRemaining()) {
                this.dataOutputStream.writeByte(src.get());
            }
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.dataOutputStream.close();
    }
}

