/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.memory.UnsafeDirectByteBufferAllocator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class UnsafeDirectByteBufferFactoryTest {
    UnsafeDirectByteBufferFactoryTest() {
    }

    @Test
    void shouldAllocateBuffer() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        try (UnsafeDirectByteBufferAllocator factory = new UnsafeDirectByteBufferAllocator();){
            int bufferSize = 128;
            factory.allocate(bufferSize, (MemoryTracker)tracker);
            Assertions.assertEquals((long)bufferSize, (long)tracker.usedNativeMemory());
        }
    }

    @Test
    void shouldFreeOnClose() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        try (UnsafeDirectByteBufferAllocator factory = new UnsafeDirectByteBufferAllocator();){
            factory.allocate(256, (MemoryTracker)tracker);
        }
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
    }

    @Test
    void shouldHandleMultipleClose() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        UnsafeDirectByteBufferAllocator factory = new UnsafeDirectByteBufferAllocator();
        factory.allocate(256, (MemoryTracker)tracker);
        factory.close();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
        factory.close();
        Assertions.assertEquals((long)0L, (long)tracker.usedNativeMemory());
    }

    @Test
    void shouldNotAllocateAfterClosed() {
        LocalMemoryTracker localMemoryTracker = new LocalMemoryTracker();
        UnsafeDirectByteBufferAllocator factory = new UnsafeDirectByteBufferAllocator();
        factory.close();
        try {
            factory.allocate(8, (MemoryTracker)localMemoryTracker);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

