/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.ReadableChannel;

public class InputStreamReadableChannel
implements ReadableChannel {
    private final DataInputStream dataInputStream;
    private boolean isClosed;

    public InputStreamReadableChannel(InputStream inputStream) {
        this.dataInputStream = new DataInputStream(inputStream);
    }

    @Override
    public byte get() throws IOException {
        return this.dataInputStream.readByte();
    }

    @Override
    public short getShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    @Override
    public int getInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    @Override
    public long getLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    @Override
    public float getFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    @Override
    public double getDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws IOException {
        this.dataInputStream.read(bytes, 0, length);
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.dataInputStream.close();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int remaining = dst.remaining();
        if (dst.hasArray()) {
            return this.dataInputStream.read(dst.array(), dst.position(), remaining);
        }
        while (dst.hasRemaining()) {
            dst.put(this.dataInputStream.readByte());
        }
        return remaining;
    }

    @Override
    public void beginChecksum() {
    }

    @Override
    public int getChecksum() {
        return 0;
    }

    @Override
    public int endChecksumAndValidate() throws IOException {
        return 0;
    }

    @Override
    public long position() throws IOException {
        throw new UnsupportedOperationException("Steam does not have a position");
    }

    @Override
    public void position(long byteOffset) throws IOException {
        throw new UnsupportedOperationException("Steam does not have a position");
    }
}

