/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.neo4j.jdbc.utils.ExceptionBuilder;
import org.neo4j.jdbc.utils.Neo4jJdbcRuntimeException;

public abstract class Neo4jDriver
implements Driver {
    protected static final String JDBC_PREFIX = "jdbc:neo4j:";
    private String driverPrefix;

    protected Neo4jDriver(String prefix) {
        this.driverPrefix = prefix;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        String[] pieces = url.split(":");
        if (pieces.length > 3 && url.startsWith(JDBC_PREFIX)) {
            if (this.driverPrefix != null) {
                if (pieces[2].matches(this.driverPrefix)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected String getPrefix() {
        return this.driverPrefix;
    }

    protected Properties parseUrlProperties(String url, Properties params) {
        Properties properties = new Properties();
        if (params != null) {
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                properties.put(entry.getKey().toString().toLowerCase(), entry.getValue());
            }
        }
        if (url.contains("?")) {
            String[] props;
            String urlProps = url.substring(url.indexOf(63) + 1);
            urlProps = this.decodeUrlComponent(urlProps);
            for (String prop : props = urlProps.split("[,&]")) {
                int idx;
                int idx1 = prop.indexOf(61);
                int idx2 = prop.indexOf(58);
                int n = idx = idx1 != -1 && idx2 != -1 ? Math.min(idx1, idx2) : Math.max(idx1, idx2);
                if (idx != -1) {
                    String key = prop.substring(0, idx);
                    String value = prop.substring(idx + 1);
                    if (properties.containsKey(key.toLowerCase())) {
                        properties.put(key.toLowerCase(), Arrays.asList(properties.getProperty(key.toLowerCase()), value));
                        continue;
                    }
                    properties.put(key.toLowerCase(), value);
                    continue;
                }
                properties.put(prop.toLowerCase(), "true");
            }
            properties.put("user", this.getUser(properties));
        }
        return properties;
    }

    private String decodeUrlComponent(String urlProps) {
        try {
            return URLDecoder.decode(urlProps, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Neo4jJdbcRuntimeException(e);
        }
    }

    protected String getUser(Properties properties) {
        String user = properties.getProperty("user");
        if (user != null && !user.trim().isEmpty()) {
            return user;
        }
        user = properties.getProperty("username");
        if (user != null && !user.trim().isEmpty()) {
            return user;
        }
        return "neo4j";
    }
}

