/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.jdbc.Neo4jDriver;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;

public abstract class BoltNeo4jDriverImpl
extends Neo4jDriver {
    public static final String TRUST_STRATEGY_KEY = "trust.strategy";
    public static final String TRUSTED_CERTIFICATE_KEY = "trusted.certificate.file";

    protected BoltNeo4jDriverImpl(String prefix) {
        super(prefix);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        BoltNeo4jConnection connection = null;
        if (this.acceptsURL(url)) {
            String boltUrl = url.replace("jdbc:neo4j:", "").replaceAll("^(" + this.getPrefix() + ":)([^/])", "$1//$2");
            try {
                Properties info = this.parseUrlProperties(boltUrl, props);
                boltUrl = this.removeUrlProperties(boltUrl);
                Config.ConfigBuilder builder = Config.build();
                if (info.containsKey("nossl")) {
                    builder = builder.withoutEncryption();
                }
                builder = this.setTrustStrategy(info, builder);
                Config config = builder.toConfig();
                AuthToken authToken = this.getAuthToken(info);
                Properties routingContext = this.getRoutingContext(boltUrl, info);
                boltUrl = this.addRoutingPolicy(boltUrl, routingContext);
                List<URI> routingUris = this.buildRoutingUris(boltUrl, routingContext);
                Driver driver = this.getDriver(routingUris, config, authToken);
                connection = BoltNeo4jConnectionImpl.newInstance(driver, info, url);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return connection;
    }

    protected abstract Driver getDriver(List<URI> var1, Config var2, AuthToken var3) throws URISyntaxException;

    private AuthToken getAuthToken(Properties properties) {
        if (properties.isEmpty() || !properties.containsKey("user") && !properties.containsKey("password")) {
            return AuthTokens.none();
        }
        return AuthTokens.basic(properties.getProperty("user"), properties.getProperty("password"));
    }

    private String removeUrlProperties(String url) {
        String boltUrl = url;
        if (boltUrl.indexOf(63) != -1) {
            boltUrl = url.substring(0, url.indexOf(63));
        }
        return boltUrl;
    }

    protected abstract Properties getRoutingContext(String var1, Properties var2);

    protected abstract String addRoutingPolicy(String var1, Properties var2);

    protected abstract List<URI> buildRoutingUris(String var1, Properties var2) throws URISyntaxException;

    private Config.ConfigBuilder setTrustStrategy(Properties properties, Config.ConfigBuilder builder) throws SQLException {
        Config.ConfigBuilder newBuilder = builder;
        if (properties.containsKey(TRUST_STRATEGY_KEY)) {
            Config.TrustStrategy.Strategy strategy;
            try {
                strategy = Config.TrustStrategy.Strategy.valueOf((String)properties.get(TRUST_STRATEGY_KEY));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid value for trust.strategy param.", e);
            }
            switch (strategy) {
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
                    break;
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: 
                case TRUST_ON_FIRST_USE: 
                case TRUST_SIGNED_CERTIFICATES: {
                    newBuilder = this.handleTrustStrategyWithFile(properties, strategy, builder);
                    break;
                }
                default: {
                    newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
                }
            }
        }
        return newBuilder;
    }

    private Config.ConfigBuilder handleTrustStrategyWithFile(Properties properties, Config.TrustStrategy.Strategy strategy, Config.ConfigBuilder builder) throws SQLException {
        if (properties.containsKey(TRUSTED_CERTIFICATE_KEY)) {
            Object file = properties.get(TRUSTED_CERTIFICATE_KEY);
            if (file instanceof File) {
                Config.ConfigBuilder newBuilder;
                switch (strategy) {
                    case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                        newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File)file));
                        break;
                    }
                    case TRUST_ON_FIRST_USE: {
                        newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustOnFirstUse((File)file));
                        break;
                    }
                    case TRUST_SIGNED_CERTIFICATES: {
                        newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustSignedBy((File)file));
                        break;
                    }
                    default: {
                        newBuilder = builder;
                    }
                }
                return newBuilder;
            }
            throw new SQLException("Invalid parameter 'trusted.certificate.file' : NOT A VALID FILE");
        }
        throw new SQLException("Missing parameter 'trusted.certificate.file' : A FILE IS REQUIRED");
    }
}

