/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.neo4j.jdbc.Neo4jArray;

public class ListArray
extends Neo4jArray {
    private List list;
    private int type;
    private static final String TYPE_NOT_SUPPORTED = "Type %s not supported";

    public ListArray(List list, int type) {
        this.list = list;
        this.type = type;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        String name;
        if (!TYPES_SUPPORTED.contains(this.type)) {
            throw new SQLException(String.format(TYPE_NOT_SUPPORTED, this.type));
        }
        switch (this.type) {
            case 12: {
                name = "VARCHAR";
                break;
            }
            case 4: {
                name = "INTEGER";
                break;
            }
            case 16: {
                name = "BOOLEAN";
                break;
            }
            case 8: {
                name = "DOUBLE";
                break;
            }
            case 2000: {
                name = "JAVA_OBJECT";
                break;
            }
            default: {
                throw new SQLException(String.format(TYPE_NOT_SUPPORTED, this.type));
            }
        }
        return name;
    }

    @Override
    public int getBaseType() throws SQLException {
        if (!TYPES_SUPPORTED.contains(this.type)) {
            throw new SQLException(String.format(TYPE_NOT_SUPPORTED, this.type));
        }
        return this.type;
    }

    @Override
    public Object getArray() throws SQLException {
        Object[] result;
        if (!TYPES_SUPPORTED.contains(this.type)) {
            throw new SQLException(String.format(TYPE_NOT_SUPPORTED, this.type));
        }
        try {
            switch (this.type) {
                case 12: {
                    result = this.list.toArray(new String[this.list.size()]);
                    break;
                }
                case 4: {
                    result = this.list.toArray(new Long[this.list.size()]);
                    break;
                }
                case 16: {
                    result = this.list.toArray(new Boolean[this.list.size()]);
                    break;
                }
                case 8: {
                    result = this.list.toArray(new Double[this.list.size()]);
                    break;
                }
                case 2000: {
                    result = this.list.toArray(new Object[this.list.size()]);
                    break;
                }
                default: {
                    throw new SQLException(String.format(TYPE_NOT_SUPPORTED, this.type));
                }
            }
        }
        catch (ArrayStoreException e) {
            throw new SQLException(e);
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof ListArray && this.list.equals(((ListArray)o).list);
    }

    public int hashCode() {
        return Objects.hash(this.list, this.type);
    }
}

