/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ResultSetHelper;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Objects;
import org.apache.commons.text.StrBuilder;

public class ResultSetHelperService
implements ResultSetHelper {
    protected static final int CLOBBUFFERSIZE = 2048;
    static final String DEFAULT_DATE_FORMAT = "dd-MMM-yyyy";
    static final String DEFAULT_TIMESTAMP_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private String dateFormat = "dd-MMM-yyyy";
    private String dateTimeFormat = "dd-MMM-yyyy HH:mm:ss";

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public String[] getColumnNames(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        String[] nameArray = new String[metadata.getColumnCount()];
        for (int i = 0; i < metadata.getColumnCount(); ++i) {
            nameArray[i] = metadata.getColumnLabel(i + 1);
        }
        return nameArray;
    }

    @Override
    public String[] getColumnValues(ResultSet rs) throws SQLException, IOException {
        return this.getColumnValues(rs, false, this.dateFormat, this.dateTimeFormat);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim) throws SQLException, IOException {
        return this.getColumnValues(rs, trim, this.dateFormat, this.dateTimeFormat);
    }

    @Override
    public String[] getColumnValues(ResultSet rs, boolean trim, String dateFormatString, String timeFormatString) throws SQLException, IOException {
        ResultSetMetaData metadata = rs.getMetaData();
        String[] valueArray = new String[metadata.getColumnCount()];
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            valueArray[i - 1] = this.getColumnValue(rs, metadata.getColumnType(i), i, trim, dateFormatString, timeFormatString);
        }
        return valueArray;
    }

    protected String handleTimestamp(Timestamp timestamp, String timestampFormatString) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(timestampFormatString);
        return timestamp == null ? null : timeFormat.format(timestamp);
    }

    private String getColumnValue(ResultSet rs, int colType, int colIndex, boolean trim, String dateFormatString, String timestampFormatString) throws SQLException, IOException {
        String value = "";
        switch (colType) {
            case -7: 
            case 2000: {
                value = Objects.toString(rs.getObject(colIndex), "");
                break;
            }
            case 16: {
                value = Objects.toString(rs.getBoolean(colIndex));
                break;
            }
            case 2011: {
                NClob nc = rs.getNClob(colIndex);
                if (nc == null) break;
                StrBuilder sb = new StrBuilder();
                sb.readFrom(nc.getCharacterStream());
                value = sb.toString();
                break;
            }
            case 2005: {
                Clob c = rs.getClob(colIndex);
                if (c == null) break;
                StrBuilder sb = new StrBuilder();
                sb.readFrom(c.getCharacterStream());
                value = sb.toString();
                break;
            }
            case -5: {
                value = Objects.toString(rs.getLong(colIndex));
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                value = Objects.toString(rs.getBigDecimal(colIndex), "");
                break;
            }
            case 8: {
                value = Objects.toString(rs.getDouble(colIndex));
                break;
            }
            case 6: {
                value = Objects.toString(Float.valueOf(rs.getFloat(colIndex)));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                value = Objects.toString(rs.getInt(colIndex));
                break;
            }
            case 91: {
                Date date = rs.getDate(colIndex);
                if (date == null) break;
                SimpleDateFormat df = new SimpleDateFormat(dateFormatString);
                value = df.format(date);
                break;
            }
            case 92: {
                value = Objects.toString(rs.getTime(colIndex), "");
                break;
            }
            case 93: {
                value = this.handleTimestamp(rs.getTimestamp(colIndex), timestampFormatString);
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                String nColumnValue = rs.getNString(colIndex);
                if (trim && nColumnValue != null) {
                    value = nColumnValue.trim();
                    break;
                }
                value = nColumnValue;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String columnValue = rs.getString(colIndex);
                if (trim && columnValue != null) {
                    value = columnValue.trim();
                    break;
                }
                value = columnValue;
                break;
            }
            default: {
                value = "";
            }
        }
        if (rs.wasNull() || value == null) {
            value = "";
        }
        return value;
    }
}

