/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.jdbc.bolt.DriverFactory;
import org.neo4j.jdbc.bolt.cache.BoltDriverCache;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jDriverImpl;

public class BoltDriver
extends BoltNeo4jDriverImpl {
    public static final String JDBC_BOLT_PREFIX = "^bolt(\\+s|\\+ssc)?$";
    private static final BoltDriverCache cache = new BoltDriverCache(params -> GraphDatabase.driver(params.getRoutingUris().get(0), params.getAuthToken(), params.getConfig()));
    private final DriverFactory driverFactory;

    public BoltDriver() throws SQLException {
        this(cache::getDriver);
    }

    protected BoltDriver(DriverFactory driverFactory) {
        super(JDBC_BOLT_PREFIX);
        this.driverFactory = driverFactory;
    }

    @Override
    protected Driver getDriver(List<URI> routingUris, Config config, AuthToken authToken, Properties info) {
        return this.driverFactory.createDriver(routingUris, config, authToken, info);
    }

    @Override
    protected Properties getRoutingContext(String url, Properties properties) {
        return new Properties();
    }

    @Override
    protected String addRoutingPolicy(String url, Properties properties) {
        return url;
    }

    @Override
    protected List<URI> buildRoutingUris(String boltUrl, Properties properties) throws URISyntaxException {
        return Arrays.asList(new URI(boltUrl));
    }

    static {
        try {
            BoltDriver driver = new BoltDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

