/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.github.resilience4j.retry.internal.RetryImpl;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Retry {
    public static Retry of(String name, RetryConfig retryConfig) {
        return Retry.of(name, retryConfig, HashMap.empty());
    }

    public static Retry of(String name, RetryConfig retryConfig, Map<String, String> tags) {
        return new RetryImpl(name, retryConfig, tags);
    }

    public static Retry of(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return Retry.of(name, retryConfigSupplier.get(), HashMap.empty());
    }

    public static Retry of(String name, Supplier<RetryConfig> retryConfigSupplier, Map<String, String> tags) {
        return new RetryImpl(name, retryConfigSupplier.get(), tags);
    }

    public static Retry ofDefaults(String name) {
        return Retry.of(name, RetryConfig.ofDefaults(), HashMap.empty());
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(Retry retry, ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            AsyncRetryBlock block = new AsyncRetryBlock(scheduler, retry.asyncContext(), supplier, promise);
            block.run();
            return promise;
        };
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Retry retry, CheckedFunction0<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.apply())) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Retry retry, CheckedRunnable runnable) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onComplete();
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Retry retry, CheckedFunction1<T, R> function) {
        return t -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = function.apply(t))) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Retry retry, Supplier<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.get())) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <E extends Exception, T> Supplier<Either<E, T>> decorateEitherSupplier(Retry retry, Supplier<Either<E, T>> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                Either result;
                if ((result = (Either)supplier.get()).isRight()) {
                    boolean validationOfResult = context.onResult(result.get());
                    if (validationOfResult) continue;
                    context.onComplete();
                    return result;
                }
                Exception exception = (Exception)result.getLeft();
                try {
                    context.onError((Exception)result.getLeft());
                }
                catch (Exception e) {
                    return Either.left(exception);
                }
            }
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(Retry retry, Supplier<Try<T>> supplier) {
        return () -> {
            Try result;
            Context context = retry.context();
            while (true) {
                if ((result = (Try)supplier.get()).isSuccess()) {
                    boolean validationOfResult = context.onResult(result.get());
                    if (validationOfResult) continue;
                    context.onComplete();
                    return result;
                }
                Throwable cause = result.getCause();
                if (!(cause instanceof Exception)) break;
                try {
                    context.onError((Exception)result.getCause());
                }
                catch (Exception e) {
                    return result;
                }
            }
            return result;
        };
    }

    public static <T> Callable<T> decorateCallable(Retry retry, Callable<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.call())) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static Runnable decorateRunnable(Retry retry, Runnable runnable) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onComplete();
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Retry retry, Function<T, R> function) {
        return t -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = function.apply(t))) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public String getName();

    public <T> Context<T> context();

    public <T> AsyncContext<T> asyncContext();

    public RetryConfig getRetryConfig();

    public Map<String, String> getTags();

    public EventPublisher getEventPublisher();

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return Retry.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Retry.decorateSupplier(this, supplier).get();
    }

    default public <E extends Exception, T> Either<E, T> executeEitherSupplier(Supplier<Either<E, T>> supplier) {
        return Retry.decorateEitherSupplier(this, supplier).get();
    }

    default public <T> Try<T> executeTrySupplier(Supplier<Try<T>> supplier) {
        return Retry.decorateTrySupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Retry.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Retry.decorateRunnable(this, runnable).run();
    }

    default public <T> CompletionStage<T> executeCompletionStage(ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return Retry.decorateCompletionStage(this, scheduler, supplier).get();
    }

    public Metrics getMetrics();

    public static interface Context<T> {
        @Deprecated
        public void onSuccess();

        public void onComplete();

        public boolean onResult(T var1);

        public void onError(Exception var1) throws Exception;

        public void onRuntimeError(RuntimeException var1);
    }

    public static class AsyncRetryBlock<T>
    implements Runnable {
        private final ScheduledExecutorService scheduler;
        private final AsyncContext<T> retryContext;
        private final Supplier<CompletionStage<T>> supplier;
        private final CompletableFuture<T> promise;

        AsyncRetryBlock(ScheduledExecutorService scheduler, AsyncContext<T> retryContext, Supplier<CompletionStage<T>> supplier, CompletableFuture<T> promise) {
            this.scheduler = scheduler;
            this.retryContext = retryContext;
            this.supplier = supplier;
            this.promise = promise;
        }

        @Override
        public void run() {
            CompletionStage<Object> stage = this.supplier.get();
            stage.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof Exception) {
                        this.onError((Exception)throwable);
                    } else {
                        this.promise.completeExceptionally((Throwable)throwable);
                    }
                } else {
                    this.onResult(result);
                }
            });
        }

        private void onError(Exception t) {
            long delay = this.retryContext.onError(t);
            if (delay < 1L) {
                this.promise.completeExceptionally(t);
            } else {
                this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        private void onResult(T result) {
            long delay = this.retryContext.onResult(result);
            if (delay < 1L) {
                try {
                    this.retryContext.onComplete();
                    this.promise.complete(result);
                }
                catch (Exception e) {
                    this.promise.completeExceptionally(e);
                }
            } else {
                this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static interface AsyncContext<T> {
        @Deprecated
        public void onSuccess();

        public void onComplete();

        public long onError(Throwable var1);

        public long onResult(T var1);
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RetryEvent> {
        public EventPublisher onRetry(EventConsumer<RetryOnRetryEvent> var1);

        public EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<RetryOnErrorEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> var1);
    }

    public static interface Metrics {
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt();

        public long getNumberOfFailedCallsWithoutRetryAttempt();

        public long getNumberOfSuccessfulCallsWithRetryAttempt();

        public long getNumberOfFailedCallsWithRetryAttempt();
    }
}

