/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.neo4j.driver.Result;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.jdbc.Neo4jStatement;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.bolt.BoltNeo4jResultSet;
import org.neo4j.jdbc.bolt.ResultSetFactory;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;
import org.neo4j.jdbc.utils.BoltNeo4jUtils;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;

public class BoltNeo4jStatement
extends Neo4jStatement {
    private final ResultSetFactory resultSetFactory;

    BoltNeo4jStatement(BoltNeo4jConnectionImpl connection, ResultSetFactory resultSetFactory, int ... rsParams) {
        super(connection);
        this.resultSetFactory = resultSetFactory;
        this.resultSetParams = rsParams;
        this.batchStatements = new ArrayList();
    }

    public static Statement newInstance(boolean debug, BoltNeo4jConnectionImpl connection, int ... rsParams) {
        BoltNeo4jStatement statement = new BoltNeo4jStatement(connection, BoltNeo4jResultSet::newInstance, rsParams);
        statement.setDebug(debug);
        return (Statement)Proxy.newProxyInstance(BoltNeo4jStatement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new Neo4jInvocationHandler(statement, debug));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeInternal(sql, result -> {
            this.currentResultSet = this.resultSetFactory.create(this.hasDebug(), this, (Result)result, this.resultSetParams);
            this.currentUpdateCount = -1;
            return this.currentResultSet;
        });
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeInternal(sql, result -> {
            SummaryCounters stats = result.consume().counters();
            this.currentUpdateCount = BoltNeo4jUtils.calculateUpdateCount(stats);
            this.currentResultSet = null;
            return this.currentUpdateCount;
        });
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean hasResultSet = BoltNeo4jUtils.hasResultSet((BoltNeo4jConnection)((Object)this.connection), sql);
        return this.executeInternal(sql, result -> {
            if (result != null) {
                if (hasResultSet) {
                    this.currentResultSet = BoltNeo4jResultSet.newInstance(this.hasDebug(), this, result, this.resultSetParams);
                    this.currentUpdateCount = -1;
                } else {
                    this.currentResultSet = null;
                    SummaryCounters stats = result.consume().counters();
                    this.currentUpdateCount = BoltNeo4jUtils.calculateUpdateCount(stats);
                }
            }
            return hasResultSet;
        });
    }

    private <T> T executeInternal(String statement, Function<Result, T> body) throws SQLException {
        this.checkClosed();
        return BoltNeo4jUtils.executeInTx((BoltNeo4jConnection)((Object)this.connection), statement, body);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        int[] result = new int[]{};
        try {
            BoltNeo4jConnection connection = (BoltNeo4jConnection)((Object)this.connection);
            for (String query : this.batchStatements) {
                int count = BoltNeo4jUtils.executeInTx(connection, query, statementResult -> {
                    SummaryCounters counters = statementResult.consume().counters();
                    return counters.nodesCreated() + counters.nodesDeleted();
                });
                result = Arrays.copyOf(result, result.length + 1);
                result[result.length - 1] = count;
            }
        }
        catch (Exception e) {
            throw new BatchUpdateException(result, (Throwable)e);
        }
        return result;
    }

    List<String> getBatchStatements() {
        return this.batchStatements;
    }
}

