/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http.driver;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.neo4j.jdbc.http.driver.Neo4jResult;

public class Neo4jResponse {
    private Integer code;
    private String location;
    private List<Neo4jResult> results;
    private List<SQLException> errors;

    public Neo4jResponse(HttpResponse response, ObjectMapper mapper) throws SQLException {
        if (response.getStatusLine() != null) {
            this.saveCodeAndLocation(response);
            HttpEntity json = response.getEntity();
            if (json != null) {
                try (InputStream is = json.getContent();){
                    Map body = mapper.readValue(is, Map.class);
                    this.parseErrors(body);
                    this.parseData(body);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
        } else {
            throw new SQLException("Receive request without status code ...");
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public String getLocation() {
        return this.location;
    }

    public List<Neo4jResult> getResults() {
        return this.results;
    }

    public Neo4jResult getFirstResult() {
        if (this.results != null && !this.results.isEmpty()) {
            return this.results.get(0);
        }
        return null;
    }

    public List<SQLException> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        Boolean hasErrors = Boolean.FALSE;
        if (this.errors != null && !this.errors.isEmpty()) {
            hasErrors = Boolean.TRUE;
        }
        return hasErrors;
    }

    public boolean hasResultSets() {
        Boolean hasResultSets = Boolean.FALSE;
        if (this.results != null && !this.results.isEmpty()) {
            for (int i = 0; i < this.results.size() && !hasResultSets.booleanValue(); ++i) {
                Neo4jResult result = this.results.get(i);
                if ((result.getColumns() == null || result.getColumns().size() <= 0) && (result.getRows() == null || result.getRows().size() <= 0)) continue;
                hasResultSets = Boolean.TRUE;
            }
        }
        return hasResultSets;
    }

    public String displayErrors() {
        StringBuilder sb = new StringBuilder();
        if (this.hasErrors()) {
            sb.append("Some errors occurred : \n");
            for (SQLException error : this.errors) {
                sb.append("[").append(error.getSQLState()).append("]").append(":").append(error.getMessage()).append("\n");
            }
        }
        return sb.toString();
    }

    private void saveCodeAndLocation(HttpResponse response) {
        this.code = response.getStatusLine().getStatusCode();
        if (this.code == 201) {
            this.location = response.getFirstHeader("Location").getValue();
        }
    }

    private void parseErrors(Map body) {
        this.errors = new ArrayList<SQLException>();
        for (Map error : (List)body.get("errors")) {
            String message = "";
            String errorCode = "";
            if (error.get("message") != null) {
                message = (String)error.get("message");
            }
            if (error.get("code") != null) {
                errorCode = (String)error.get("code");
            }
            this.errors.add(new SQLException(message, errorCode));
        }
    }

    private void parseData(Map body) {
        this.results = new ArrayList<Neo4jResult>();
        if (body.containsKey("results")) {
            for (Map map : (List)body.get("results")) {
                this.results.add(new Neo4jResult(map));
            }
        }
    }
}

