/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Neo4jInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(Neo4jInvocationHandler.class.getName());
    private final Map<String, Method> methods = new HashMap<String, Method>();
    private Object target;
    private boolean debug;

    public Neo4jInvocationHandler(Object target, boolean debug) {
        this.target = target;
        this.debug = debug;
        for (Method method : target.getClass().getMethods()) {
            String key = this.getUniqueKeyFromMethod(method);
            this.methods.put(key, method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object result = this.methods.get(this.getUniqueKeyFromMethod(method)).invoke(this.target, args);
            if (this.debug) {
                LOGGER.info("[" + this.target.getClass().getCanonicalName() + "] " + method.getName());
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private String getUniqueKeyFromMethod(Method method) {
        String key = method.getName() + "_";
        for (Class<?> type : method.getParameterTypes()) {
            key = key + type.getCanonicalName() + "_";
        }
        return key;
    }
}

