/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ObjectConverter {
    private static final Map<String, Method> CONVERTERS;

    private ObjectConverter() {
    }

    public static <T> T convert(Object from, Class<T> to) {
        if (from == null) {
            return null;
        }
        if (to.isAssignableFrom(from.getClass())) {
            return to.cast(from);
        }
        String converterId = from.getClass().getName() + "_" + to.getCanonicalName();
        String genericConverterId = "any_" + to.getCanonicalName();
        Method converter = CONVERTERS.get(converterId);
        if (converter == null) {
            converter = CONVERTERS.get(genericConverterId);
        }
        if (converter == null) {
            throw new UnsupportedOperationException("Cannot convert from " + from.getClass().getName() + " to " + to.getCanonicalName() + ". Requested converter does not exist.");
        }
        try {
            return to.cast(converter.invoke(to, from));
        }
        catch (Exception e) {
            throw new ClassCastException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Conversion failed with " + e.getMessage());
        }
    }

    public static Map anyToMap(Object value) {
        return (Map)value;
    }

    public static Boolean integerToBoolean(Integer value) {
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Integer booleanToInteger(Boolean value) {
        return value != false ? 1 : 0;
    }

    public static Short booleanToShort(Boolean value) {
        return value != false ? (short)1 : 0;
    }

    public static Double booleanToDouble(Boolean value) {
        return value != false ? 1.0 : 0.0;
    }

    public static Float booleanToFloat(Boolean value) {
        return Float.valueOf(value != false ? 1.0f : 0.0f);
    }

    public static Long booleanToLong(Boolean value) {
        return value != false ? 1L : 0L;
    }

    public static String integerToString(Integer value) {
        return value.toString();
    }

    public static String longToString(Long value) {
        return value.toString();
    }

    public static Integer stringToInteger(String value) {
        return Integer.valueOf(value);
    }

    public static Long stringToLong(String value) {
        return Long.valueOf(value);
    }

    public static Float longToFloat(Long value) {
        return Float.valueOf(value.floatValue());
    }

    public static Short longToShort(Long value) {
        return value.shortValue();
    }

    public static Integer longToInteger(Long value) {
        return value.intValue();
    }

    public static Float stringToFloat(String value) {
        return Float.valueOf(value);
    }

    public static String booleanToString(Boolean value) {
        return value.toString();
    }

    public static Boolean stringToBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static Double longToDouble(Long value) {
        return value.doubleValue();
    }

    public static Double stringToDouble(String value) {
        return Double.valueOf(value);
    }

    public static Short stringToShort(String value) {
        return Short.valueOf(value);
    }

    static {
        Method[] methods;
        CONVERTERS = new HashMap<String, Method>();
        for (Method method : methods = ObjectConverter.class.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1) continue;
            if (method.getParameterTypes()[0] == Object.class) {
                CONVERTERS.put("any_" + method.getReturnType().getName(), method);
                continue;
            }
            CONVERTERS.put(method.getParameterTypes()[0].getName() + "_" + method.getReturnType().getName(), method);
        }
    }
}

