/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.jdbc.Neo4jCallableStatement;
import org.neo4j.jdbc.Neo4jTransactionSupplier;
import org.neo4j.jdbc.PreparedStatementImpl;

final class CallableStatementImpl
extends PreparedStatementImpl
implements Neo4jCallableStatement {
    private static final Logger LOGGER = Logger.getLogger("org.neo4j.jdbc.callable-statement");
    private ParameterType parameterType;
    private static final Pattern PARAMETER_LIST_SPLITTER = Pattern.compile(",(?=(?:[^\"']*[\"'][^\"']*[\"'])*[^\"']*\\Z)");
    private static final String VALID_IDENTIFIER = "\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*";
    private static final Predicate<String> IS_NUMBER = Pattern.compile("\\$?[1-9]+").asMatchPredicate();
    private static final Pattern VALID_IDENTIFIER_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*");
    private static final String WS = "\\s*+";
    private static final String RETURN_PARAMETER = "(?<returnParameter>\\s*+(?:\\?|(?<returnParameterName>[$:]" + VALID_IDENTIFIER_PATTERN.pattern() + "))\\s*+=\\s*+)?";
    private static final String PARAMETER_LIST = "(?:\\((?<parameterList>.*)\\))?";
    public static final String FQN_AND_PARAMETER_LIST = "(?<fqn>\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*)\\s*+(?:\\((?<parameterList>.*)\\))?";
    private static final Pattern JDBC_CALL = Pattern.compile("(?i)\\s*+\\{" + RETURN_PARAMETER + "call \\s*+(?<fqn>\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*)\\s*+(?:\\((?<parameterList>.*)\\))?\\s*+}");
    private static final Pattern CYPHER_RETURN_CALL = Pattern.compile("(?i)\\s*+RETURN \\s*+(?<fqn>\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*)\\s*+(?:\\((?<parameterList>.*)\\))?");
    private static final Pattern CYPHER_YIELD_CALL = Pattern.compile("(?i)\\s*+CALL \\s*+(?<fqn>\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*)\\s*+(?:\\((?<parameterList>.*)\\))?\\s*+YIELD \\s*+(\\*|(?<yieldedValues>" + VALID_IDENTIFIER_PATTERN.pattern() + "(?:,\\s*+" + VALID_IDENTIFIER_PATTERN.pattern() + ")*))");
    private static final Pattern CYPHER_SIDE_EFFECT_CALL = Pattern.compile("(?i)\\s*+CALL \\s*+(?<fqn>\\p{javaJavaIdentifierStart}[.\\p{javaJavaIdentifierPart}]*)\\s*+(?:\\((?<parameterList>.*)\\))?");

    static CallableStatement prepareCall(Connection connection, Neo4jTransactionSupplier transactionSupplier, boolean rewriteBatchedStatements, String sql) throws SQLException {
        Descriptor descriptor = CallableStatementImpl.parse(sql);
        HashMap<String, Integer> parameterOrder = new HashMap<String, Integer>();
        DatabaseMetaData meta = connection.getMetaData();
        if (descriptor.isFunctionCall() == null) {
            boolean isFunction;
            try (ResultSet procedures = meta.getProcedures(null, null, descriptor.fqn());){
                isFunction = !procedures.next();
            }
            descriptor = new Descriptor(descriptor.fqn, descriptor.returnType, descriptor.yieldedValues, descriptor.parameterList, isFunction);
        }
        if (descriptor.isUsingNamedParameters()) {
            try (ResultSet columns = descriptor.isFunctionCall() != false ? meta.getFunctionColumns(null, null, descriptor.fqn(), null) : meta.getProcedureColumns(null, null, descriptor.fqn(), null);){
                while (columns.next()) {
                    parameterOrder.put(columns.getString("COLUMN_NAME"), columns.getInt("ORDINAL_POSITION"));
                }
            }
            for (String value : descriptor.parameterList.namedParameters().values()) {
                if (parameterOrder.containsKey(value)) continue;
                throw new SQLException("Procedure `" + descriptor.fqn() + "` does not have a named parameter `" + value + "`");
            }
        }
        return new CallableStatementImpl(connection, transactionSupplier, rewriteBatchedStatements, descriptor.toCypher(parameterOrder));
    }

    CallableStatementImpl(Connection connection, Neo4jTransactionSupplier transactionSupplier, boolean rewriteBatchedStatements, String sql) {
        super(connection, transactionSupplier, UnaryOperator.identity(), null, rewriteBatchedStatements, sql);
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.parameterType = null;
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.parameterType = null;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) {
        LOGGER.log(Level.WARNING, () -> "Registering out parameter %d with type %d (ignored)".formatted(parameterIndex, sqlType));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) {
        LOGGER.log(Level.WARNING, () -> "Registering out parameter %d with type %d and scale %d (ignored)".formatted(parameterIndex, sqlType, scale));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.assertCallAndPositionAtFirstRow().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getDouble(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) {
        LOGGER.log(Level.WARNING, () -> "Registering out parameter %d with type %d and type %s (ignored)".formatted(parameterIndex, sqlType, typeName));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) {
        LOGGER.log(Level.WARNING, () -> "Registering out parameter `%s`with type %d (ignored)".formatted(parameterName, sqlType));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) {
        LOGGER.log(Level.WARNING, () -> "Registering out parameter `%s`with type %d and scale %d (ignored)".formatted(parameterName, sqlType, scale));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) {
        LOGGER.log(Level.WARNING, () -> "Registering out parameter `%s` with type %d and type %s (ignored)".formatted(parameterName, sqlType, typeName));
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getURL(parameterIndex);
    }

    @Override
    public void setURL(String parameterName, URL value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        Objects.requireNonNull(parameterName);
        super.setURL(parameterName, value);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setNull(parameterName, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setBoolean(parameterName, value);
    }

    @Override
    public void setByte(String parameterName, byte value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setByte(parameterName, value);
    }

    @Override
    public void setShort(String parameterName, short value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setShort(parameterName, value);
    }

    @Override
    public void setInt(String parameterName, int value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setInt(parameterName, value);
    }

    @Override
    public void setLong(String parameterName, long value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setLong(parameterName, value);
    }

    @Override
    public void setFloat(String parameterName, float value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setFloat(parameterName, value);
    }

    @Override
    public void setDouble(String parameterName, double value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setDouble(parameterName, value);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setBigDecimal(parameterName, value);
    }

    @Override
    public void setString(String parameterName, String value) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setString(parameterName, value);
    }

    @Override
    public void setBytes(String parameterName, byte[] bytes) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setBytes(parameterName, bytes);
    }

    @Override
    public void setDate(String parameterName, Date date) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setDate(parameterName, date);
    }

    @Override
    public void setTime(String parameterName, Time time) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setTime(parameterName, time);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setTimestamp(parameterName, timestamp);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setAsciiStream0(parameterName, inputStream, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setBinaryStream0(parameterName, inputStream, length);
    }

    @Override
    public void setObject(String parameterName, Object object, int targetSqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object object, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(String parameterName, Object object) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setObject(parameterName, object);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setCharacterStream0(parameterName, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date date, Calendar calendar) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setDate0(parameterName, date, calendar);
    }

    @Override
    public void setTime(String parameterName, Time time, Calendar calendar) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setTime0(parameterName, time, calendar);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setTimestamp0(parameterName, timestamp, calendar);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setNull(parameterName, sqlType);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getString(parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBoolean(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getByte(parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getShort(parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getInt(parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getLong(parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getFloat(parameterName);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getDouble(parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBytes(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getDate(parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTime(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTimestamp(parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getObject(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBigDecimal(parameterName);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getObject(parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getRef(parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getBlob(parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getClob(parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getArray(parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getDate(parameterName, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getURL(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getRowId(parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getNClob(parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getSQLXML(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getNString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getNCharacterStream(parameterName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getCharacterStream(parameterName);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(parameterName, x, CallableStatementImpl.getLengthAsInt(length));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterName, x, CallableStatementImpl.getLengthAsInt(length));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterName, reader, CallableStatementImpl.getLengthAsInt(length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setAsciiStream(parameterName, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setBinaryStream(parameterName, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.assertParameterType(ParameterType.NAMED);
        super.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.assertCallAndPositionAtFirstRow().getObject(parameterName, type);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setBoolean(parameterIndex, value);
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setByte(parameterIndex, value);
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setShort(parameterIndex, value);
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setInt(parameterIndex, value);
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setLong(parameterIndex, value);
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setFloat(parameterIndex, value);
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setDouble(parameterIndex, value);
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setString(parameterIndex, value);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setURL(parameterIndex, url);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setBytes(parameterIndex, bytes);
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setDate(parameterIndex, date);
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setTime(parameterIndex, time);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setAsciiStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setObject(int parameterIndex, Object object) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setObject(parameterIndex, object);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar calendar) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setDate(parameterIndex, date, calendar);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar calendar) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setTime(parameterIndex, time, calendar);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setTimestamp(parameterIndex, timestamp, calendar);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setAsciiStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.assertParameterType(ParameterType.ORDINAL);
        super.setCharacterStream(parameterIndex, reader, length);
    }

    private void assertParameterType(ParameterType parameterType) throws SQLException {
        if (this.parameterType == null) {
            this.parameterType = parameterType;
        } else if (this.parameterType != parameterType) {
            throw new SQLException(String.format("%s parameter can not be mixed with %s parameter(s)", new Object[]{parameterType, this.parameterType}));
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw CallableStatementImpl.newIllegalMethodInvocation();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw CallableStatementImpl.newIllegalMethodInvocation();
    }

    static ParameterListDescriptor parseParameterList(String parameterList) {
        Object v;
        if (parameterList == null) {
            return new ParameterListDescriptor(Map.of(), Map.of(), Map.of());
        }
        HashMap<Integer, Integer> ordinalParameters = new HashMap<Integer, Integer>();
        HashMap<Integer, String> namedParameters = new HashMap<Integer, String>();
        HashMap<Integer, String> constants = new HashMap<Integer, String>();
        int cnt = 0;
        for (String s : PARAMETER_LIST_SPLITTER.split(parameterList.trim())) {
            ++cnt;
            String possibleParameter = s.trim();
            if (possibleParameter.isEmpty()) continue;
            if ("?".equals(possibleParameter)) {
                ordinalParameters.put(cnt, -1);
                continue;
            }
            if (IS_NUMBER.test(possibleParameter)) {
                ordinalParameters.put(cnt, Integer.parseInt(possibleParameter.replace("$", "")));
                continue;
            }
            if (possibleParameter.startsWith("$") || possibleParameter.startsWith(":")) {
                v = possibleParameter.substring(1);
                Matcher matcher = VALID_IDENTIFIER_PATTERN.matcher((CharSequence)v);
                if (!matcher.matches() && !"0".equals(v)) continue;
                namedParameters.put(cnt, (String)v);
                continue;
            }
            constants.put(cnt, possibleParameter);
        }
        CallableStatementImpl.assertEitherOrdinalOrNamedParameters(ordinalParameters, namedParameters);
        Set used = ordinalParameters.values().stream().filter(i -> i > 0).collect(Collectors.toSet());
        int max = 1;
        for (Map.Entry<Integer, Integer> entry : ordinalParameters.entrySet()) {
            Integer key = entry.getKey();
            v = entry.getValue();
            if ((Integer)v < 0) {
                while (used.contains(max)) {
                    ++max;
                }
                v = max++;
            }
            ordinalParameters.put(key, (Integer)v);
        }
        return new ParameterListDescriptor(ordinalParameters, namedParameters, constants);
    }

    private static void assertEitherOrdinalOrNamedParameters(Map<Integer, Integer> ordinalParameters, Map<Integer, String> namedParameters) {
        if (!ordinalParameters.isEmpty() && !namedParameters.isEmpty()) {
            throw new IllegalArgumentException("Index- and named ordinalParameters cannot be mixed");
        }
    }

    static Descriptor parse(String statement) {
        if (Objects.requireNonNull(statement, "Callable statements cannot be null").isBlank()) {
            throw new IllegalArgumentException("Callable statements cannot be blank");
        }
        statement = statement.trim();
        Matcher matcher = JDBC_CALL.matcher(statement);
        try {
            if (matcher.matches()) {
                return CallableStatementImpl.describeJdbcCall(matcher);
            }
            matcher = CYPHER_RETURN_CALL.matcher(statement);
            if (matcher.matches()) {
                return CallableStatementImpl.describeCypherReturnCall(matcher);
            }
            matcher = CYPHER_YIELD_CALL.matcher(statement);
            if (matcher.matches()) {
                return CallableStatementImpl.describeCypherYieldCall(matcher);
            }
            matcher = CYPHER_SIDE_EFFECT_CALL.matcher(statement);
            if (matcher.matches()) {
                return CallableStatementImpl.describeCypherSideEffectCall(matcher);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage() + ": `" + statement + "`");
        }
        throw new IllegalArgumentException("Cannot create a callable statement from `" + statement + "`");
    }

    private static Descriptor describeCypherSideEffectCall(Matcher matcher) {
        ParameterListDescriptor parameterList = CallableStatementImpl.parseParameterList(matcher.group("parameterList"));
        return new Descriptor(matcher.group("fqn"), ReturnType.NONE, null, parameterList, false);
    }

    private static Descriptor describeCypherYieldCall(Matcher matcher) {
        String yieldedStuff = Optional.ofNullable(matcher.group("yieldedValues")).map(String::trim).orElse("");
        ArrayList<String> returnParameterName = new ArrayList<String>();
        for (String s : PARAMETER_LIST_SPLITTER.split(yieldedStuff)) {
            if (s.isBlank()) continue;
            returnParameterName.add(s.trim());
        }
        ReturnType returnType = returnParameterName.isEmpty() ? ReturnType.ORDINAL : ReturnType.NAMED;
        ParameterListDescriptor parameterList = CallableStatementImpl.parseParameterList(matcher.group("parameterList"));
        return new Descriptor(matcher.group("fqn"), returnType, returnParameterName, parameterList, false);
    }

    private static Descriptor describeCypherReturnCall(Matcher matcher) {
        ParameterListDescriptor parameterList = CallableStatementImpl.parseParameterList(matcher.group("parameterList"));
        return new Descriptor(matcher.group("fqn"), ReturnType.ORDINAL, null, parameterList, true);
    }

    private static Descriptor describeJdbcCall(Matcher matcher) {
        String returnParameter = Optional.ofNullable(matcher.group("returnParameter")).map(String::trim).orElse("");
        ReturnType returnType = ReturnType.NONE;
        ArrayList<String> returnParameterName = new ArrayList<String>();
        if (!returnParameter.isBlank()) {
            Optional.ofNullable(matcher.group("returnParameterName")).map(String::trim).map(s -> s.substring(1)).ifPresent(returnParameterName::add);
            returnType = returnParameterName.isEmpty() ? ReturnType.ORDINAL : ReturnType.NAMED;
        }
        ParameterListDescriptor parameterList = CallableStatementImpl.parseParameterList(matcher.group("parameterList"));
        return new Descriptor(matcher.group("fqn"), returnType, returnParameterName, parameterList, null);
    }

    record Descriptor(String fqn, ReturnType returnType, List<String> yieldedValues, ParameterListDescriptor parameterList, Boolean isFunctionCall) {
        Descriptor {
            if (yieldedValues != null && !yieldedValues.isEmpty() && returnType != ReturnType.NAMED) {
                throw new IllegalArgumentException("A name for the return parameter is only supported with named returns");
            }
            if (returnType == ReturnType.NAMED && !parameterList.ordinalParameters.isEmpty() || !parameterList.ordinalParameters.isEmpty() && !parameterList.namedParameters().isEmpty()) {
                throw new IllegalArgumentException("Index- and named ordinalParameters cannot be mixed");
            }
            if (!parameterList.namedParameters.isEmpty() && !parameterList.constants.isEmpty()) {
                throw new IllegalArgumentException("Named parameters cannot be used together with constant arguments");
            }
        }

        boolean isUsingNamedParameters() {
            return !this.parameterList.namedParameters.isEmpty();
        }

        String toCypher(Map<String, Integer> parameterOrder) {
            StringBuilder sb = new StringBuilder();
            boolean isSafeFunctionCall = Boolean.TRUE.equals(this.isFunctionCall);
            if (isSafeFunctionCall) {
                sb.append("RETURN");
            } else {
                sb.append("CALL");
            }
            sb.append(" ").append(this.fqn).append(this.parameterList.toCypher(parameterOrder));
            if (this.returnType == ReturnType.ORDINAL && !isSafeFunctionCall) {
                sb.append(" YIELD *");
            } else if (this.returnType == ReturnType.NAMED) {
                sb.append(" YIELD ").append(String.join((CharSequence)", ", this.yieldedValues));
            }
            return sb.toString();
        }
    }

    static enum ReturnType {
        NONE,
        ORDINAL,
        NAMED,
        YIELD;

    }

    record ParameterListDescriptor(Map<Integer, Integer> ordinalParameters, Map<Integer, String> namedParameters, Map<Integer, String> constants) {
        String toCypher(Map<String, Integer> parameterOrder) {
            if (this.ordinalParameters.isEmpty() && this.namedParameters().isEmpty() && this.constants.isEmpty()) {
                return "";
            }
            TreeMap<Integer, String> all = new TreeMap<Integer, String>();
            this.ordinalParameters.forEach((k, v) -> all.put((Integer)k, "$" + v));
            this.namedParameters.forEach((k, v) -> {
                Integer idx = parameterOrder.getOrDefault(v, (Integer)k);
                all.put(idx, "$" + v);
            });
            all.putAll(this.constants);
            return all.values().stream().collect(Collectors.joining(", ", "(", ")"));
        }
    }

    private static enum ParameterType {
        ORDINAL,
        NAMED;

    }
}

