/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.util.function.Supplier;
import org.neo4j.jdbc.ThrowingSupplier;

final class Lazy<T, E extends Throwable> {
    private final ThrowingSupplier<T, E> supplier;
    private volatile T resolved;

    static <T> Lazy<T, RuntimeException> of(Supplier<T> supplier) {
        return new Lazy(supplier::get);
    }

    static <T, E extends Throwable> Lazy<T, E> of(ThrowingSupplier<T, E> supplier) {
        return new Lazy<T, E>(supplier);
    }

    private Lazy(ThrowingSupplier<T, E> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T resolve() throws E {
        T result = this.resolved;
        if (result == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.resolved;
                if (result == null) {
                    result = this.resolved = this.supplier.get();
                }
            }
        }
        return result;
    }

    boolean isResolved() {
        return this.resolved != null;
    }
}

