/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class Neo4jConversions {
    private Neo4jConversions() {
    }

    static int toSqlTypeFromOldCypherType(String neo4jType) {
        return Neo4jConversions.toSqlType(Neo4jConversions.valueOfV5Name(neo4jType));
    }

    static String oldCypherTypesToNew(String neo4jType) {
        return switch (neo4jType) {
            case "Boolean" -> "BOOLEAN";
            case "Double" -> "FLOAT";
            case "Long" -> "INTEGER";
            case "String" -> "STRING";
            case "Point" -> "POINT";
            case "StringArray", "ByteArray", "DoubleArray", "LongArray" -> "LIST";
            case "Date" -> "DATE";
            case "Duration" -> "DURATION";
            case "DateTime" -> "ZONED DATETIME";
            case "Time" -> "ZONED TIME";
            case "LocalDateTime" -> "LOCAL DATETIME";
            case "LocalTime" -> "LOCAL TIME";
            case "Null" -> "NULL";
            case "Any" -> "ANY";
            default -> "OTHER";
        };
    }

    static int toSqlType(Type neo4jType) {
        return switch (neo4jType) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ANY, Type.DURATION -> 1111;
            case Type.BOOLEAN -> 16;
            case Type.BYTES -> 2004;
            case Type.STRING -> 12;
            case Type.NUMBER -> -5;
            case Type.INTEGER -> 4;
            case Type.FLOAT -> 6;
            case Type.LIST -> 2003;
            case Type.MAP, Type.POINT, Type.PATH, Type.RELATIONSHIP, Type.NODE -> 2002;
            case Type.DATE -> 91;
            case Type.TIME -> 92;
            case Type.DATE_TIME, Type.LOCAL_DATE_TIME, Type.LOCAL_TIME -> 93;
            case Type.NULL -> 0;
        };
    }

    static Type valueOfV5Name(String in) {
        String value;
        value = switch (value = in.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ROOT)) {
            case "LONG" -> Type.INTEGER.name();
            case "DOUBLE" -> Type.FLOAT.name();
            default -> value.endsWith("ARRAY") ? Type.LIST.name() : value;
        };
        return Type.valueOf(value);
    }

    private static ZoneOffset getZoneOffsetFrom(Calendar cal) {
        return Objects.requireNonNullElseGet(cal, Calendar::getInstance).getTimeZone().toZoneId().getRules().getOffset(cal.toInstant());
    }

    static Value asValue(Time time, Calendar calendar) {
        if (time == null) {
            return Values.NULL;
        }
        OffsetTime offsetTime = time.toLocalTime().atOffset(Neo4jConversions.getZoneOffsetFrom(calendar));
        return Values.value(offsetTime);
    }

    static Time asTime(Value value) throws SQLException {
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        if (Type.TIME.isTypeOf(value)) {
            return Time.valueOf(value.asOffsetTime().toLocalTime());
        }
        if (Type.LOCAL_TIME.isTypeOf(value)) {
            return Time.valueOf(value.asLocalTime());
        }
        if (Type.DATE_TIME.isTypeOf(value)) {
            return Time.valueOf(value.asZonedDateTime().toLocalTime());
        }
        if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            return Time.valueOf(value.asLocalDateTime().toLocalTime());
        }
        throw new SQLException(String.format("%s value cannot be mapped to java.sql.Time", new Object[]{value.type()}));
    }

    static Time asTime(Value value, Calendar calendar) throws SQLException {
        OffsetTime offsetTime;
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        ZoneOffset targetOffset = Neo4jConversions.getZoneOffsetFrom(calendar);
        if (Type.TIME.isTypeOf(value)) {
            offsetTime = value.asOffsetTime().withOffsetSameInstant(targetOffset);
        } else if (Type.LOCAL_TIME.isTypeOf(value)) {
            offsetTime = value.asLocalTime().atOffset(targetOffset);
        } else if (Type.DATE_TIME.isTypeOf(value)) {
            offsetTime = value.asZonedDateTime().toOffsetDateTime().withOffsetSameInstant(targetOffset).toOffsetTime();
        } else if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            offsetTime = value.asLocalDateTime().toLocalTime().atOffset(targetOffset);
        } else {
            throw new SQLException(String.format("%s value cannot be mapped to java.sql.Time", new Object[]{value.type()}));
        }
        return Time.valueOf(offsetTime.toLocalTime());
    }

    static Value asValue(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return Values.NULL;
        }
        calendar = Objects.requireNonNullElseGet(calendar, Calendar::getInstance);
        ZonedDateTime zonedDateTime = timestamp.toLocalDateTime().atZone(calendar.getTimeZone().toZoneId());
        return Values.value(zonedDateTime);
    }

    static Timestamp asTimestamp(Value value) throws SQLException {
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        if (Type.DATE_TIME.isTypeOf(value)) {
            return Timestamp.valueOf(value.asZonedDateTime().toLocalDateTime());
        }
        if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            return Timestamp.valueOf(value.asLocalDateTime());
        }
        throw new SQLException(String.format("%s value cannot be mapped to java.sql.Timestamp", new Object[]{value.type()}));
    }

    static Timestamp asTimestamp(Value value, Calendar calendar) throws SQLException {
        ZonedDateTime hlp;
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        ZoneId zonedDateTime = calendar.getTimeZone().toZoneId();
        if (Type.DATE_TIME.isTypeOf(value)) {
            hlp = value.asZonedDateTime().withZoneSameInstant(zonedDateTime);
        } else if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            hlp = value.asLocalDateTime().atZone(zonedDateTime);
        } else {
            throw new SQLException(String.format("%s value cannot be mapped to java.sql.Timestamp", new Object[]{value.type()}));
        }
        return Timestamp.valueOf(hlp.toLocalDateTime());
    }

    static Value asValue(Date date, Calendar calendar) {
        if (date == null) {
            return Values.NULL;
        }
        calendar = Objects.requireNonNullElseGet(calendar, Calendar::getInstance);
        ZonedDateTime zonedDateTime = date.toLocalDate().atStartOfDay(calendar.getTimeZone().toZoneId());
        return Values.value(zonedDateTime);
    }

    static Date asDate(Value value) throws SQLException {
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        if (Type.DATE.isTypeOf(value)) {
            return Date.valueOf(value.asLocalDate());
        }
        if (Type.DATE_TIME.isTypeOf(value)) {
            return Date.valueOf(value.asZonedDateTime().toLocalDate());
        }
        if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            return Date.valueOf(value.asLocalDateTime().toLocalDate());
        }
        throw new SQLException(String.format("%s value cannot be mapped to java.sql.Date", new Object[]{value.type()}));
    }

    static Date asDate(Value value, Calendar calendar) throws SQLException {
        ZonedDateTime zonedDateTime;
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        ZoneId targetZone = calendar.getTimeZone().toZoneId();
        if (Type.DATE.isTypeOf(value)) {
            zonedDateTime = value.asLocalDate().atStartOfDay(targetZone);
        } else if (Type.DATE_TIME.isTypeOf(value)) {
            zonedDateTime = value.asZonedDateTime().withZoneSameInstant(targetZone);
        } else if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            zonedDateTime = value.asLocalDateTime().atZone(targetZone);
        } else {
            throw new SQLException(String.format("%s value cannot be mapped to java.sql.Date", new Object[]{value.type()}));
        }
        return Date.valueOf(zonedDateTime.toLocalDate());
    }
}

