/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.neo4j.jdbc.Neo4jDataSourceExtensions;

public final class Neo4jDataSource
implements Neo4jDataSourceExtensions {
    private String databaseName;
    private String transportProtocol;
    private char[] password;
    private int portNumber = 7687;
    private String serverName;
    private String user;
    private int loginTimeout = 1;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private final Properties connectionProperties = new Properties();

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getPassword() {
        return this.password == null ? null : new String(this.password);
    }

    @Override
    public void setPassword(String password) {
        this.password = password != null ? password.toCharArray() : null;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    String getUrl() {
        return "jdbc:neo4j%s://%s:%d/%s?timeout=%d".formatted(Optional.ofNullable(this.transportProtocol).map(String::trim).filter(Predicate.not(String::isBlank)).map(p -> "+" + p).orElse(""), Objects.requireNonNull(this.serverName, "The server name must be specified on the data source"), this.portNumber, Optional.ofNullable(this.databaseName).orElse("neo4j"), this.loginTimeout * 1000);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties newProperties = new Properties();
        this.connectionProperties.stringPropertyNames().forEach(k -> newProperties.put(k, this.connectionProperties.getProperty((String)k)));
        if (username != null && password != null) {
            newProperties.setProperty("user", username);
            newProperties.setProperty("password", password);
        }
        return DriverManager.getConnection(this.getUrl(), newProperties);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = Objects.requireNonNull(out, "Log writer must not be null");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getPackageName());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("This object does not implement the given interface");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public void setConnectionProperty(String name, String value) {
        this.connectionProperties.setProperty(name, value);
    }
}

