/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.jdbc.Bookmark;
import org.neo4j.jdbc.BookmarkManager;
import org.neo4j.jdbc.ConnectionImpl;
import org.neo4j.jdbc.DefaultBookmarkManagerImpl;
import org.neo4j.jdbc.DriverThreadFactory;
import org.neo4j.jdbc.Neo4jDriverExtensions;
import org.neo4j.jdbc.ProductVersion;
import org.neo4j.jdbc.TranslatorComparator;
import org.neo4j.jdbc.VoidBookmarkManagerImpl;
import org.neo4j.jdbc.internal.bolt.BoltAdapters;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.AuthTokens;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseNameUtil;
import org.neo4j.jdbc.internal.shaded.bolt.DefaultDomainNameResolver;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.RoutingContext;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlans;
import org.neo4j.jdbc.internal.shaded.bolt.netty.NettyBoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.dotenv.Dotenv;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvBuilder;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.jdbc.translator.spi.Translator;
import org.neo4j.jdbc.translator.spi.TranslatorFactory;

public final class Neo4jDriver
implements Neo4jDriverExtensions {
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_DATABASE = "database";
    public static final String PROPERTY_USER_AGENT = "agent";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_AUTH_SCHEME = "authScheme";
    public static final String PROPERTY_AUTH_REALM = "authRealm";
    public static final String PROPERTY_TIMEOUT = "timeout";
    public static final String PROPERTY_SQL_TRANSLATION_ENABLED = "enableSQLTranslation";
    public static final String PROPERTY_USE_BOOKMARKS = "useBookmarks";
    public static final String PROPERTY_REWRITE_PLACEHOLDERS = "rewritePlaceholders";
    public static final String PROPERTY_SQL_TRANSLATION_CACHING_ENABLED = "cacheSQLTranslations";
    public static final String PROPERTY_TRANSLATOR_FACTORY = "translatorFactory";
    public static final String PROPERTY_REWRITE_BATCHED_STATEMENTS = "rewriteBatchedStatements";
    public static final String PROPERTY_SSL = "ssl";
    public static final String PROPERTY_RELATIONSHIP_SAMPLE_SIZE = "relationshipSampleSize";
    public static final String PROPERTY_SSL_MODE = "sslMode";
    private static final EventLoopGroup DEFAULT_EVENT_LOOP_GROUP = new NioEventLoopGroup(new DriverThreadFactory());
    private static final String URL_REGEX = "^jdbc:neo4j(?:\\+(?<transport>s(?:sc)?)?)?://(?<host>[^:/?]+):?(?<port>\\d+)?/?(?<database>[^?]+)?\\??(?<urlParams>\\S+)?$";
    public static final Pattern URL_PATTERN = Pattern.compile("^jdbc:neo4j(?:\\+(?<transport>s(?:sc)?)?)?://(?<host>[^:/?]+):?(?<port>\\d+)?/?(?<database>[^?]+)?\\??(?<urlParams>\\S+)?$");
    private static final BoltProtocolVersion MIN_BOLT_VERSION = new BoltProtocolVersion(5, 1);
    private final BoltConnectionProvider boltConnectionProvider;
    private volatile List<TranslatorFactory> sqlTranslatorFactories;
    private final Map<DriverConfig, BookmarkManager> bookmarkManagers = new ConcurrentHashMap<DriverConfig, BookmarkManager>();
    private final Map<String, Object> transactionMetadata = new ConcurrentHashMap<String, Object>();

    public static SpecifyAdditionalPropertiesStep withSQLTranslation() {
        return new BuilderImpl(true, Map.of());
    }

    public static SpecifyTranslationStep withProperties(Map<String, Object> additionalProperties) {
        return new BuilderImpl(false, additionalProperties);
    }

    public static Optional<Connection> fromEnv() throws SQLException {
        return Neo4jDriver.fromEnv(null, null);
    }

    public static Optional<Connection> fromEnv(Path directory) throws SQLException {
        return Neo4jDriver.fromEnv(directory, null);
    }

    public static Optional<Connection> fromEnv(String filename) throws SQLException {
        return Neo4jDriver.fromEnv(null, filename);
    }

    public static Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
        return new BuilderImpl(false, Map.of()).fromEnv(directory, filename);
    }

    public Neo4jDriver() {
        this(new NettyBoltConnectionProvider(DEFAULT_EVENT_LOOP_GROUP, Clock.systemUTC(), DefaultDomainNameResolver.getInstance(), null, BoltAdapters.newLoggingProvider(), BoltAdapters.getValueFactory(), null));
    }

    Neo4jDriver(BoltConnectionProvider boltConnectionProvider) {
        this.boltConnectionProvider = boltConnectionProvider;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        DriverConfig driverConfig = DriverConfig.of(url, info);
        BoltServerAddress address = new BoltServerAddress(driverConfig.host, driverConfig.port);
        SecurityPlan securityPlan = Neo4jDriver.parseSSLParams(driverConfig.sslProperties);
        String databaseName = driverConfig.database;
        String user = driverConfig.user == null || driverConfig.user.isBlank() ? "" : driverConfig.user;
        String password = driverConfig.password == null || driverConfig.password.isBlank() ? "" : driverConfig.password;
        String authRealm = driverConfig.authRealm == null || driverConfig.authRealm.isBlank() ? null : driverConfig.authRealm;
        ValueFactory valueFactory = BoltAdapters.getValueFactory();
        AuthToken authToken = switch (driverConfig.authScheme) {
            default -> throw new IncompatibleClassChangeError();
            case AuthScheme.NONE -> AuthTokens.none(valueFactory);
            case AuthScheme.BASIC -> AuthTokens.basic(user, password, authRealm, valueFactory);
            case AuthScheme.BEARER -> AuthTokens.bearer(password, valueFactory);
            case AuthScheme.KERBEROS -> AuthTokens.kerberos(password, valueFactory);
        };
        String userAgent = driverConfig.agent;
        int connectTimeoutMillis = driverConfig.timeout;
        boolean enableSqlTranslation = driverConfig.enableSQLTranslation;
        boolean enableTranslationCaching = driverConfig.enableTranslationCaching;
        boolean rewriteBatchedStatements = driverConfig.rewriteBatchedStatements;
        boolean rewritePlaceholders = driverConfig.rewritePlaceholders;
        String translatorFactory = driverConfig.rawConfig.get(PROPERTY_TRANSLATOR_FACTORY);
        BookmarkManager bookmarkManager = this.bookmarkManagers.computeIfAbsent(driverConfig, k -> driverConfig.useBookmarks ? new DefaultBookmarkManagerImpl() : new VoidBookmarkManagerImpl());
        Supplier<List<TranslatorFactory>> translatorFactoriesSupplier = this::getSqlTranslatorFactories;
        if (translatorFactory != null && !translatorFactory.isBlank()) {
            translatorFactoriesSupplier = () -> this.getSqlTranslatorFactory(translatorFactory);
        }
        return new ConnectionImpl(driverConfig.toUrl(), () -> this.establishBoltConnection(address, userAgent, connectTimeoutMillis, securityPlan, databaseName, authToken), Neo4jDriver.getSqlTranslatorSupplier(enableSqlTranslation, driverConfig.rawConfig(), translatorFactoriesSupplier), enableSqlTranslation, enableTranslationCaching, rewriteBatchedStatements, rewritePlaceholders, bookmarkManager, this.transactionMetadata, driverConfig.relationshipSampleSize(), databaseName);
    }

    private BoltConnection establishBoltConnection(BoltServerAddress address, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, String databaseName, AuthToken authToken) {
        return this.boltConnectionProvider.connect(address, RoutingContext.EMPTY, BoltAdapters.newAgent(ProductVersion.getValue()), userAgent, connectTimeoutMillis, securityPlan, DatabaseNameUtil.database(databaseName), () -> CompletableFuture.completedStage(authToken), AccessMode.WRITE, Collections.emptySet(), null, MIN_BOLT_VERSION, NotificationConfig.defaultConfig(), ignored -> {}, Collections.emptyMap()).toCompletableFuture().join();
    }

    static String getDefaultUserAgent() {
        return "neo4j-jdbc/%s".formatted(ProductVersion.getValue());
    }

    static Map<String, String> mergeConfig(String[] urlParams, Properties jdbcProperties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : jdbcProperties.stringPropertyNames()) {
            String value = jdbcProperties.getProperty(name);
            if (value == null) continue;
            result.put(name, value);
        }
        String regex = "^(?<name>\\S+)=(?<value>\\S+)$";
        Pattern pattern = Pattern.compile(regex);
        for (String param : urlParams) {
            Matcher matcher = pattern.matcher(param);
            if (!matcher.matches()) continue;
            String name = URLDecoder.decode(matcher.group("name"), StandardCharsets.UTF_8);
            String value = URLDecoder.decode(matcher.group("value"), StandardCharsets.UTF_8);
            result.put(name, value);
        }
        return Map.copyOf(result);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("url cannot be null");
        }
        return URL_PATTERN.matcher(url).matches();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverConfig parsedConfig = DriverConfig.of(url, info);
        ArrayList<DriverPropertyInfo> driverPropertyInfos = new ArrayList<DriverPropertyInfo>();
        String[] trueFalseChoices = new String[]{"true", "false"};
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_HOST, parsedConfig.host, "The host name", true, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_PORT, String.valueOf(parsedConfig.port), "The port", true, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_DATABASE, parsedConfig.database, "The database name to connect to. Will default to neo4j if left blank.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_USER, parsedConfig.user, "The user that will be used to connect. Will be defaulted to neo4j if left blank.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_PASSWORD, parsedConfig.password, "The password that is used to connect. Defaults to 'password'.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_AUTH_SCHEME, parsedConfig.authScheme.getName(), "The authentication scheme to use. Defaults to 'basic'.", false, (String[])Arrays.stream(AuthScheme.values()).map(AuthScheme::getName).toArray(String[]::new)));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_AUTH_REALM, parsedConfig.authRealm, "The authentication realm to use. Defaults to ''.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_USER_AGENT, parsedConfig.agent, "User agent to send to server, can be found in logs later.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_TIMEOUT, String.valueOf(parsedConfig.timeout), "Timeout for connection interactions. Defaults to 1000.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SQL_TRANSLATION_ENABLED, String.valueOf(parsedConfig.enableSQLTranslation), "Turns on or of sql to cypher translation. Defaults to false.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_REWRITE_BATCHED_STATEMENTS, String.valueOf(parsedConfig.rewriteBatchedStatements), "Turns on generation of more efficient cypher when batching statements. Defaults to true.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_USE_BOOKMARKS, String.valueOf(parsedConfig.useBookmarks), "Enables the use of causal cluster bookmarks. Defaults to true", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_REWRITE_PLACEHOLDERS, String.valueOf(parsedConfig.rewritePlaceholders), "Rewrites SQL placeholders (?) into $1, $2 .. $n. Defaults to true when SQL translation is not enabled.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SQL_TRANSLATION_CACHING_ENABLED, String.valueOf(parsedConfig.enableTranslationCaching), "Enable caching of translations.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SSL, String.valueOf(parsedConfig.sslProperties.ssl), "SSL enabled", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SSL_MODE, parsedConfig.sslProperties().sslMode.getName(), "The mode for ssl. Accepted values are: require, verify-full, disable.", false, (String[])Arrays.stream(SSLMode.values()).map(SSLMode::getName).toArray(String[]::new)));
        parsedConfig.misc().forEach((k, v) -> driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(k, v, "", false, null)));
        return (DriverPropertyInfo[])driverPropertyInfos.toArray(DriverPropertyInfo[]::new);
    }

    private static DriverPropertyInfo newDriverPropertyInfo(String name, String value, String description, boolean required, String[] choices) {
        DriverPropertyInfo result = new DriverPropertyInfo(name, value);
        result.description = description;
        result.required = required;
        result.choices = choices;
        return result;
    }

    @Override
    public int getMajorVersion() {
        return ProductVersion.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return ProductVersion.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getPackageName());
    }

    private static String[] splitUrlParams(String urlParams) {
        if (urlParams != null) {
            return urlParams.split("&");
        }
        return new String[0];
    }

    private static SecurityPlan parseSSLParams(SSLProperties sslProperties) throws SQLException {
        SecurityPlan securityPlan;
        switch (sslProperties.sslMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REQUIRE: {
                try {
                    SecurityPlan securityPlan2;
                    securityPlan = securityPlan2 = SecurityPlans.encryptedForAnyCertificate();
                    break;
                }
                catch (GeneralSecurityException ex) {
                    throw new SQLException(ex);
                }
            }
            case VERIFY_FULL: {
                try {
                    SecurityPlan securityPlan3;
                    securityPlan = securityPlan3 = SecurityPlans.encryptedForSystemCASignedCertificates();
                    break;
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw new SQLException(ex);
                }
            }
            case DISABLE: {
                SecurityPlan securityPlan4;
                securityPlan = securityPlan4 = SecurityPlans.unencrypted();
            }
        }
        return securityPlan;
    }

    private static SSLMode sslMode(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        try {
            return SSLMode.valueOf(text.toUpperCase(Locale.ROOT).replace("-", "_"));
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException(String.format("%s is not a valid option for SSLMode", text));
        }
    }

    private static SSLProperties parseSSLProperties(Map<String, String> info, String transport) throws SQLException {
        SSLMode sslMode = Neo4jDriver.sslMode(info.get(PROPERTY_SSL_MODE));
        Boolean ssl = null;
        String sslString = info.get(PROPERTY_SSL);
        if (sslString != null) {
            if (!sslString.equals("true") && !sslString.equals("false")) {
                throw new SQLException("Invalid SSL option, accepts true or false");
            }
            ssl = Boolean.parseBoolean(sslString);
        }
        if (transport != null) {
            if (transport.equals("s")) {
                if (ssl != null && !ssl.booleanValue()) {
                    throw new SQLException("Invalid transport option +s when ssl option set to false, accepted ssl option is true");
                }
                ssl = true;
                if (sslMode == null) {
                    sslMode = SSLMode.VERIFY_FULL;
                } else if (sslMode == SSLMode.DISABLE) {
                    throw new SQLException("Invalid SSLMode %s for +s transport option, accepts verify-ca, verify-full, require");
                }
            } else if (transport.equals("ssc")) {
                if (ssl != null && !ssl.booleanValue()) {
                    throw new SQLException("Invalid transport option +ssc when ssl option set to false, accepted ssl option is true");
                }
                ssl = true;
                if (sslMode == null) {
                    sslMode = SSLMode.REQUIRE;
                } else if (sslMode != SSLMode.REQUIRE) {
                    throw new SQLException("Invalid SSLMode %s for +scc transport option, accepts 'require' only");
                }
            } else if (!transport.isEmpty()) {
                throw new SQLException("Invalid Transport section of the URL, accepts +s or +scc");
            }
        }
        if (ssl == null && (sslMode == SSLMode.VERIFY_FULL || sslMode == SSLMode.REQUIRE)) {
            ssl = true;
        } else if (ssl != null && sslMode == null && ssl.booleanValue()) {
            sslMode = SSLMode.REQUIRE;
        }
        if (sslMode == null) {
            sslMode = SSLMode.DISABLE;
        }
        if (ssl == null) {
            ssl = false;
        }
        if (ssl.booleanValue()) {
            if (sslMode != SSLMode.VERIFY_FULL && sslMode != SSLMode.REQUIRE) {
                throw new SQLException(String.format("Invalid sslMode %s when ssl = true, accepts verify-full and require", new Object[]{sslMode}));
            }
        } else if (sslMode != SSLMode.DISABLE) {
            throw new SQLException(String.format("Invalid sslMode %s when ssl = false, accepts disable, allow and prefer", new Object[]{sslMode}));
        }
        return new SSLProperties(sslMode, ssl);
    }

    private List<TranslatorFactory> getSqlTranslatorFactory(String translatorFactory) {
        String fqn = "DEFAULT".equalsIgnoreCase(translatorFactory) ? "org.neo4j.jdbc.translator.impl.SqlToCypherTranslatorFactory" : translatorFactory;
        try {
            Class<?> cls = Class.forName(fqn);
            return List.of((TranslatorFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException ex) {
            this.getParentLogger().log(Level.WARNING, "Translator factory {0} not found", new Object[]{fqn});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            this.getParentLogger().log(Level.WARNING, ex, () -> "Could not load translator factory");
        }
        return List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TranslatorFactory> getSqlTranslatorFactories() {
        List<TranslatorFactory> result = this.sqlTranslatorFactories;
        if (result == null) {
            Neo4jDriver neo4jDriver = this;
            synchronized (neo4jDriver) {
                result = this.sqlTranslatorFactories;
                if (result == null) {
                    result = this.sqlTranslatorFactories = ServiceLoader.load(TranslatorFactory.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).toList();
                }
            }
        }
        return result;
    }

    static Supplier<List<Translator>> getSqlTranslatorSupplier(boolean automaticSqlTranslation, Map<String, ?> config, Supplier<List<TranslatorFactory>> sqlTranslatorFactoriesSupplier) throws SQLException {
        if (automaticSqlTranslation) {
            List<TranslatorFactory> factories = sqlTranslatorFactoriesSupplier.get();
            if (factories.isEmpty()) {
                throw Neo4jDriver.noTranslatorsAvailableException();
            }
            return () -> Neo4jDriver.sortedListOfTranslators(config, factories);
        }
        Map<String, ?> localConfig = Map.copyOf(config);
        return () -> Neo4jDriver.sortedListOfTranslators(localConfig, (List)sqlTranslatorFactoriesSupplier.get());
    }

    static SQLException noTranslatorsAvailableException() {
        return new SQLException("No translators available");
    }

    private static List<Translator> sortedListOfTranslators(Map<String, ?> config, List<TranslatorFactory> factories) {
        if (factories.size() == 1) {
            Translator t1 = factories.get(0).create(config);
            return t1 != null ? List.of(t1) : List.of();
        }
        return factories.stream().map(factory -> factory.create(config)).filter(Objects::nonNull).sorted(TranslatorComparator.INSTANCE).toList();
    }

    @Override
    public Collection<Bookmark> getCurrentBookmarks(String url, Properties info) throws SQLException {
        BookmarkManager bm = this.bookmarkManagers.get(DriverConfig.of(url, info));
        if (bm == null) {
            return Set.of();
        }
        return bm.getBookmarks(Bookmark::new);
    }

    @Override
    public void addBookmarks(String url, Properties info, Collection<Bookmark> bookmarks) throws SQLException {
        BookmarkManager bm = this.bookmarkManagers.get(DriverConfig.of(url, info));
        if (bm != null) {
            bm.updateBookmarks(Bookmark::value, List.of(), bookmarks);
        }
    }

    @Override
    public Neo4jDriver withMetadata(Map<String, Object> metadata) {
        if (metadata != null) {
            this.transactionMetadata.putAll(metadata);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("This object does not implement the given interface");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    static {
        try {
            DriverManager.registerDriver(new Neo4jDriver());
        }
        catch (SQLException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private static final class BuilderImpl
    implements SpecifyAdditionalPropertiesStep,
    SpecifyTranslationStep {
        private boolean forceSqlTranslation;
        private Map<String, Object> additionalProperties;

        BuilderImpl(boolean forceSqlTranslation, Map<String, Object> additionalProperties) {
            this.forceSqlTranslation = forceSqlTranslation;
            this.additionalProperties = additionalProperties;
        }

        @Override
        public Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
            String authRealm;
            String authScheme;
            String password;
            Dotenv env;
            Object address;
            DotenvBuilder builder = Dotenv.configure().ignoreIfMissing().ignoreIfMalformed();
            if (directory != null) {
                builder = builder.directory(directory.toAbsolutePath().toString());
            }
            if (filename != null && !filename.isBlank()) {
                builder = builder.filename(filename);
            }
            if ((address = (env = builder.load()).get("NEO4J_URI")) != null && !((String)address).toLowerCase(Locale.ROOT).startsWith("jdbc:")) {
                address = "jdbc:" + (String)address;
            }
            if (address == null || !URL_PATTERN.matcher((CharSequence)address).matches()) {
                return Optional.empty();
            }
            Properties properties = new Properties();
            properties.putAll(this.additionalProperties);
            String username = env.get("NEO4J_USERNAME");
            if (username != null) {
                properties.put(Neo4jDriver.PROPERTY_USER, username);
            }
            if ((password = env.get("NEO4J_PASSWORD")) != null) {
                properties.put(Neo4jDriver.PROPERTY_PASSWORD, password);
            }
            if ((authScheme = env.get("NEO4J_AUTH_SCHEME")) != null) {
                properties.put(Neo4jDriver.PROPERTY_AUTH_SCHEME, authScheme);
            }
            if ((authRealm = env.get("NEO4J_AUTH_REALM")) != null) {
                properties.put(Neo4jDriver.PROPERTY_AUTH_REALM, authRealm);
            }
            String sql2cypher = env.get("NEO4J_SQL_TRANSLATION_ENABLED");
            if (this.forceSqlTranslation || Boolean.parseBoolean(sql2cypher)) {
                properties.put(Neo4jDriver.PROPERTY_SQL_TRANSLATION_ENABLED, "true");
            }
            return Optional.of(new Neo4jDriver().connect((String)address, properties));
        }

        @Override
        public SpecifyEnvStep withProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties = Objects.requireNonNullElseGet(additionalProperties, Map::of);
            return this;
        }

        @Override
        public SpecifyEnvStep withSQLTranslation() {
            this.forceSqlTranslation = true;
            return this;
        }
    }

    record DriverConfig(String host, int port, String database, AuthScheme authScheme, String user, String password, String authRealm, String agent, int timeout, boolean enableSQLTranslation, boolean enableTranslationCaching, boolean rewriteBatchedStatements, boolean rewritePlaceholders, boolean useBookmarks, int relationshipSampleSize, SSLProperties sslProperties, Map<String, String> rawConfig) {
        private static final Set<String> DRIVER_SPECIFIC_PROPERTIES = Set.of("host", "port", "database", "authScheme", "user", "password", "authRealm", "agent", "timeout", "enableSQLTranslation", "cacheSQLTranslations", "rewriteBatchedStatements", "rewritePlaceholders", "ssl", "sslMode");

        DriverConfig {
            rawConfig = Collections.unmodifiableMap(new TreeMap<String, String>(rawConfig));
        }

        Map<String, String> misc() {
            HashMap<String, String> misc = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.rawConfig.entrySet()) {
                if (DRIVER_SPECIFIC_PROPERTIES.contains(entry.getKey())) continue;
                misc.put(entry.getKey(), entry.getValue());
            }
            return misc;
        }

        static DriverConfig of(String url, Properties info) throws SQLException {
            String databaseName;
            if (url == null || info == null) {
                throw new SQLException("url and info cannot be null");
            }
            Matcher matcher = URL_PATTERN.matcher(url);
            if (!matcher.matches()) {
                throw new SQLException("Invalid url");
            }
            String[] urlParams = Neo4jDriver.splitUrlParams(matcher.group("urlParams"));
            Map<String, String> config = Neo4jDriver.mergeConfig(urlParams, info);
            HashMap<String, String> raw = new HashMap<String, String>(config);
            String host = matcher.group(Neo4jDriver.PROPERTY_HOST);
            raw.put(Neo4jDriver.PROPERTY_HOST, host);
            String rawPort = matcher.group(Neo4jDriver.PROPERTY_PORT);
            int port = Integer.parseInt(rawPort != null ? matcher.group(Neo4jDriver.PROPERTY_PORT) : "7687");
            if (rawPort != null) {
                raw.put(Neo4jDriver.PROPERTY_PORT, matcher.group(Neo4jDriver.PROPERTY_PORT));
            }
            if ((databaseName = matcher.group(Neo4jDriver.PROPERTY_DATABASE)) == null) {
                databaseName = config.getOrDefault(Neo4jDriver.PROPERTY_DATABASE, "neo4j");
            } else {
                raw.put(Neo4jDriver.PROPERTY_DATABASE, databaseName);
            }
            SSLProperties sslProperties = Neo4jDriver.parseSSLProperties(config, matcher.group("transport"));
            raw.put(Neo4jDriver.PROPERTY_SSL, String.valueOf(sslProperties.ssl));
            raw.put(Neo4jDriver.PROPERTY_SSL_MODE, sslProperties.sslMode.getName());
            AuthScheme authScheme = DriverConfig.authScheme(config.get(Neo4jDriver.PROPERTY_AUTH_SCHEME));
            String user = String.valueOf(config.getOrDefault(Neo4jDriver.PROPERTY_USER, "neo4j"));
            String password = String.valueOf(config.getOrDefault(Neo4jDriver.PROPERTY_PASSWORD, Neo4jDriver.PROPERTY_PASSWORD));
            String authRealm = config.getOrDefault(Neo4jDriver.PROPERTY_AUTH_REALM, "");
            String userAgent = String.valueOf(config.getOrDefault(Neo4jDriver.PROPERTY_USER_AGENT, Neo4jDriver.getDefaultUserAgent()));
            int connectionTimeoutMillis = Integer.parseInt(config.getOrDefault(Neo4jDriver.PROPERTY_TIMEOUT, "1000"));
            boolean automaticSqlTranslation = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_SQL_TRANSLATION_ENABLED, "false"));
            boolean enableTranslationCaching = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_SQL_TRANSLATION_CACHING_ENABLED, "false"));
            boolean rewriteBatchedStatements = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_REWRITE_BATCHED_STATEMENTS, "true"));
            boolean rewritePlaceholders = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_REWRITE_PLACEHOLDERS, Boolean.toString(!automaticSqlTranslation)));
            boolean useBookmarks = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_USE_BOOKMARKS, "true"));
            int relationshipSampleSize = Integer.parseInt(config.getOrDefault(Neo4jDriver.PROPERTY_RELATIONSHIP_SAMPLE_SIZE, "1000"));
            if (relationshipSampleSize < -1) {
                throw new SQLException("Sample size for relationships must be greater than or equal -1");
            }
            return new DriverConfig(host, port, databaseName, authScheme, user, password, authRealm, userAgent, connectionTimeoutMillis, automaticSqlTranslation, enableTranslationCaching, rewriteBatchedStatements, rewritePlaceholders, useBookmarks, relationshipSampleSize, sslProperties, raw);
        }

        private static AuthScheme authScheme(String scheme) throws IllegalArgumentException {
            if (scheme == null || scheme.isBlank()) {
                return AuthScheme.BASIC;
            }
            try {
                return AuthScheme.valueOf(scheme.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignored) {
                throw new IllegalArgumentException(String.format("%s is not a valid option for authScheme", scheme));
            }
        }

        URI toUrl() {
            SSLProperties sslProperties = this.sslProperties();
            StringBuilder result = new StringBuilder("jdbc:neo4j%s://%s:%s/%s?".formatted(sslProperties.protocolSuffix(), this.host(), this.port(), this.database()));
            DriverConfig.append(result, Neo4jDriver.PROPERTY_AUTH_SCHEME, (Object)this.authScheme()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_USER, this.user()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_AUTH_REALM, this.authRealm()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_USER_AGENT, this.agent()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_TIMEOUT, this.timeout()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_SQL_TRANSLATION_ENABLED, this.enableSQLTranslation()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_SQL_TRANSLATION_CACHING_ENABLED, this.enableTranslationCaching()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_REWRITE_BATCHED_STATEMENTS, this.rewriteBatchedStatements()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_REWRITE_PLACEHOLDERS, this.rewriteBatchedStatements()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_USE_BOOKMARKS, this.useBookmarks()).append("&");
            this.misc().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> DriverConfig.append(result, (String)e.getKey(), e.getValue()).append("&"));
            return URI.create(result.substring(0, result.length() - 1));
        }

        static StringBuilder append(StringBuilder result, String name, Object value) {
            result.append(URLEncoder.encode(name, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(String.valueOf(value), StandardCharsets.UTF_8));
            return result;
        }
    }

    record SSLProperties(SSLMode sslMode, boolean ssl) {
        String protocolSuffix() {
            if (!this.ssl) {
                return "";
            }
            return this.sslMode == SSLMode.VERIFY_FULL ? "+s" : "+ssc";
        }
    }

    static enum AuthScheme {
        NONE("none"),
        BASIC("basic"),
        BEARER("bearer"),
        KERBEROS("kerberos");

        private final String name;

        private AuthScheme(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static enum SSLMode {
        DISABLE("disable"),
        REQUIRE("require"),
        VERIFY_FULL("verify-full");

        private final String name;

        private SSLMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface SpecifyAdditionalPropertiesStep
    extends SpecifyEnvStep {
        public SpecifyEnvStep withProperties(Map<String, Object> var1);
    }

    public static interface SpecifyTranslationStep
    extends SpecifyEnvStep {
        public SpecifyEnvStep withSQLTranslation();
    }

    public static interface SpecifyEnvStep {
        default public Optional<Connection> fromEnv() throws SQLException {
            return this.fromEnv(null, null);
        }

        default public Optional<Connection> fromEnv(Path directory) throws SQLException {
            return this.fromEnv(directory, null);
        }

        default public Optional<Connection> fromEnv(String filename) throws SQLException {
            return this.fromEnv(null, filename);
        }

        public Optional<Connection> fromEnv(Path var1, String var2) throws SQLException;
    }
}

