/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.neo4j.jdbc.DatabaseMetadataImpl;
import org.neo4j.jdbc.Neo4jConversions;
import org.neo4j.jdbc.values.BooleanValue;
import org.neo4j.jdbc.values.BytesValue;
import org.neo4j.jdbc.values.DateTimeValue;
import org.neo4j.jdbc.values.DateValue;
import org.neo4j.jdbc.values.DurationValue;
import org.neo4j.jdbc.values.FloatValue;
import org.neo4j.jdbc.values.IntegerValue;
import org.neo4j.jdbc.values.ListValue;
import org.neo4j.jdbc.values.LocalDateTimeValue;
import org.neo4j.jdbc.values.LocalTimeValue;
import org.neo4j.jdbc.values.MapValue;
import org.neo4j.jdbc.values.NodeValue;
import org.neo4j.jdbc.values.NullValue;
import org.neo4j.jdbc.values.PathValue;
import org.neo4j.jdbc.values.PointValue;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.RelationshipValue;
import org.neo4j.jdbc.values.StringValue;
import org.neo4j.jdbc.values.TimeValue;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;

final class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private final String schemaName;
    private final String catalogName;
    private final String tableName;
    private final List<String> keys;
    private final Record firstRecord;

    ResultSetMetaDataImpl(String schemaName, String catalogName, List<String> keys, Record firstRecord) {
        this.schemaName = Objects.requireNonNullElse(schemaName, "").trim();
        this.catalogName = Objects.requireNonNullElse(catalogName, "").trim();
        this.tableName = "";
        this.keys = keys;
        this.firstRecord = firstRecord;
    }

    @Override
    public int getColumnCount() {
        return this.keys.size();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 1;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) {
        int adjustedIndex = column - 1;
        return this.keys.get(adjustedIndex);
    }

    @Override
    public String getSchemaName(int column) {
        return this.schemaName;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return DatabaseMetadataImpl.getMaxPrecision(this.getColumnType(column)).asInt(0);
    }

    @Override
    public int getScale(int column) {
        return 0;
    }

    @Override
    public String getTableName(int column) {
        return this.tableName;
    }

    @Override
    public String getCatalogName(int column) {
        return this.catalogName;
    }

    @Override
    public int getColumnType(int column) {
        if (this.firstRecord == null) {
            return 0;
        }
        int adjustedIndex = column - 1;
        Type recordType = this.firstRecord.get(adjustedIndex).type();
        return Neo4jConversions.toSqlType(recordType);
    }

    @Override
    public String getColumnTypeName(int column) {
        if (this.firstRecord == null) {
            return "";
        }
        int adjustedIndex = column - 1;
        return this.firstRecord.get(adjustedIndex).type().name();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (this.firstRecord == null) {
            return Object.class.getName();
        }
        Type type = this.firstRecord.get(column - 1).type();
        switch (type) {
            case ANY: {
                return Value.class.getName();
            }
            case BOOLEAN: {
                return BooleanValue.class.getName();
            }
            case BYTES: {
                return BytesValue.class.getName();
            }
            case STRING: {
                return StringValue.class.getName();
            }
            case NUMBER: {
                return IntegerValue.class.getName();
            }
            case INTEGER: {
                return IntegerValue.class.getName();
            }
            case FLOAT: {
                return FloatValue.class.getName();
            }
            case LIST: {
                return ListValue.class.getName();
            }
            case MAP: {
                return MapValue.class.getName();
            }
            case NODE: {
                return NodeValue.class.getName();
            }
            case RELATIONSHIP: {
                return RelationshipValue.class.getName();
            }
            case PATH: {
                return PathValue.class.getName();
            }
            case POINT: {
                return PointValue.class.getName();
            }
            case DATE: {
                return DateValue.class.getName();
            }
            case TIME: {
                return TimeValue.class.getName();
            }
            case LOCAL_TIME: {
                return LocalTimeValue.class.getName();
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeValue.class.getName();
            }
            case DATE_TIME: {
                return DateTimeValue.class.getName();
            }
            case DURATION: {
                return DurationValue.class.getName();
            }
            case NULL: {
                return NullValue.class.getName();
            }
        }
        throw new SQLException("Unknown type");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("This object does not implement the given interface");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

