/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.values.Path;
import org.neo4j.jdbc.internal.shaded.bolt.values.Segment;
import org.neo4j.jdbc.values.AsValue;
import org.neo4j.jdbc.values.Entity;
import org.neo4j.jdbc.values.Node;
import org.neo4j.jdbc.values.Path;
import org.neo4j.jdbc.values.Relationship;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class PathImpl
implements org.neo4j.jdbc.values.Path,
AsValue,
Path {
    private final List<Node> nodes;
    private final List<Relationship> relationships;
    private final List<Path.Segment> segments;

    private static boolean isEndpoint(Node node, Relationship relationship) {
        return node.elementId().equals(relationship.startNodeElementId()) || node.elementId().equals(relationship.endNodeElementId());
    }

    PathImpl(List<Entity> alternatingNodeAndRel) {
        this.nodes = this.newList(alternatingNodeAndRel.size() / 2 + 1);
        this.relationships = this.newList(alternatingNodeAndRel.size() / 2);
        this.segments = this.newList(alternatingNodeAndRel.size() / 2);
        if (alternatingNodeAndRel.size() % 2 == 0) {
            throw new IllegalArgumentException("An odd number of entities are required to build a path");
        }
        Node lastNode = null;
        Relationship lastRelationship = null;
        int index = 0;
        for (Entity entity : alternatingNodeAndRel) {
            if (entity == null) {
                throw new IllegalArgumentException("Path entities cannot be null");
            }
            if (index % 2 == 0) {
                try {
                    lastNode = (Node)entity;
                    if (!(this.nodes.isEmpty() || lastRelationship != null && PathImpl.isEndpoint(lastNode, lastRelationship))) {
                        throw new IllegalArgumentException("Node argument " + index + " is not an endpoint of relationship argument " + (index - 1));
                    }
                    this.nodes.add(lastNode);
                }
                catch (ClassCastException ex) {
                    String cls = entity.getClass().getName();
                    throw new IllegalArgumentException("Expected argument " + index + " to be a node " + index + " but found a " + cls + " instead");
                }
            }
            try {
                lastRelationship = (Relationship)entity;
                if (!PathImpl.isEndpoint(lastNode, lastRelationship)) {
                    throw new IllegalArgumentException("Node argument " + (index - 1) + " is not an endpoint of relationship argument " + index);
                }
                this.relationships.add(lastRelationship);
            }
            catch (ClassCastException ex) {
                String cls = entity.getClass().getName();
                throw new IllegalArgumentException("Expected argument " + index + " to be a relationship but found a " + cls + " instead");
            }
            ++index;
        }
        this.buildSegments();
    }

    PathImpl(Entity ... alternatingNodeAndRel) {
        this(Arrays.asList(alternatingNodeAndRel));
    }

    PathImpl(List<Path.Segment> segments, List<Node> nodes, List<Relationship> relationships) {
        this.segments = segments;
        this.nodes = nodes;
        this.relationships = relationships;
    }

    private <T> List<T> newList(int size) {
        return size == 0 ? Collections.emptyList() : new ArrayList(size);
    }

    @Override
    public int length() {
        return this.relationships.size();
    }

    @Override
    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    @Override
    public Iterable<Node> nodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    @Override
    public Node start() {
        return this.nodes.get(0);
    }

    @Override
    public Node end() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return this.segments.iterator();
    }

    @Override
    public Value asValue() {
        return Values.value((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathImpl segments1 = (PathImpl)o;
        return this.segments.equals(segments1.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return "path" + String.valueOf(this.segments);
    }

    private void buildSegments() {
        for (int i = 0; i < this.relationships.size(); ++i) {
            this.segments.add(new SelfContainedSegment(this.nodes.get(i), this.relationships.get(i), this.nodes.get(i + 1)));
        }
    }

    record SelfContainedSegment(Node start, Relationship relationship, Node end) implements Path.Segment,
    Segment
    {
        @Override
        public int hashCode() {
            return Objects.hash(this.start, this.relationship, this.end);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SelfContainedSegment that = (SelfContainedSegment)other;
            return this.start.equals(that.start) && this.end.equals(that.end) && this.relationship.equals(that.relationship);
        }

        @Override
        public String toString() {
            return String.format("(%s)-[%s:%s]->(%s)", this.start.id(), this.relationship.id(), this.relationship.type(), this.end.id());
        }
    }
}

