/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.util.Map;
import org.neo4j.jdbc.internal.bolt.AbstractEntity;
import org.neo4j.jdbc.values.Relationship;
import org.neo4j.jdbc.values.Value;

final class RelationshipImpl
extends AbstractEntity
implements Relationship,
org.neo4j.jdbc.internal.shaded.bolt.values.Relationship {
    private long start;
    private String startElementId;
    private long end;
    private String endElementId;
    private final String type;

    RelationshipImpl(long id, String elementId, long start, String startElementId, long end, String endElementId, String type, Map<String, Value> properties) {
        super(id, elementId, properties);
        this.start = start;
        this.startElementId = startElementId;
        this.end = end;
        this.endElementId = endElementId;
        this.type = type;
    }

    @Override
    public boolean hasType(String relationshipType) {
        return this.type().equals(relationshipType);
    }

    @Override
    public void setStartAndEnd(long start, String startElementId, long end, String endElementId) {
        this.start = start;
        this.startElementId = startElementId;
        this.end = end;
        this.endElementId = endElementId;
    }

    @Override
    public String startNodeElementId() {
        return this.startElementId;
    }

    @Override
    public String endNodeElementId() {
        return this.endElementId;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.format("relationship<%s>", this.id());
    }
}

