/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.jdbc.internal.bolt.ValueFactoryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.values.IsoDuration;
import org.neo4j.jdbc.internal.shaded.bolt.values.Point;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.values.AsValue;

final class ValueImpl
implements Value,
AsValue {
    private final org.neo4j.jdbc.values.Value value;
    private final Type type;

    ValueImpl(org.neo4j.jdbc.values.Value value, Type type) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean asBoolean() {
        return this.value.asBoolean();
    }

    @Override
    public byte[] asByteArray() {
        return this.value.asByteArray();
    }

    @Override
    public String asString() {
        return this.value.asString();
    }

    @Override
    public long asLong() {
        return this.value.asLong();
    }

    @Override
    public double asDouble() {
        return this.value.asDouble();
    }

    @Override
    public LocalDate asLocalDate() {
        return this.value.asLocalDate();
    }

    @Override
    public OffsetTime asOffsetTime() {
        return this.value.asOffsetTime();
    }

    @Override
    public LocalTime asLocalTime() {
        return this.value.asLocalTime();
    }

    @Override
    public LocalDateTime asLocalDateTime() {
        return this.value.asLocalDateTime();
    }

    @Override
    public ZonedDateTime asZonedDateTime() {
        return this.value.asZonedDateTime();
    }

    @Override
    public IsoDuration asIsoDuration() {
        return (IsoDuration)((Object)this.value.asIsoDuration());
    }

    @Override
    public Point asPoint() {
        return (Point)((Object)this.value.asPoint());
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public Iterable<String> keys() {
        return this.value.keys();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public Value get(String key) {
        return ValueFactoryImpl.asBoltValue(this.value.get(key));
    }

    @Override
    public Iterable<Value> values() {
        final org.neo4j.jdbc.values.Value value = this.value;
        return () -> new Iterator<Value>(){
            private final Iterator<org.neo4j.jdbc.values.Value> iterator;
            {
                this.iterator = value.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Value next() {
                return ValueFactoryImpl.asBoltValue(this.iterator.next());
            }
        };
    }

    @Override
    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        return this.value.asMap(mapFunction.compose(ValueFactoryImpl::asBoltValue));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueImpl boltValue = (ValueImpl)o;
        return Objects.equals(this.value, boltValue.value) && this.type == boltValue.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public org.neo4j.jdbc.values.Value asValue() {
        return this.value;
    }
}

