/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseName;
import org.neo4j.jdbc.internal.shaded.bolt.DomainNameResolver;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.MetricsListener;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.RoutingContext;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.exception.MinVersionAcquisitionException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.BoltConnectionImpl;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.ConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.ConnectionProviders;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.NettyLogging;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.NoopMetricsListener;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v4.BoltProtocolV4;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v51.BoltProtocolV51;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.util.FutureUtil;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.jdbc.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NettyBoltConnectionProvider
implements BoltConnectionProvider {
    private final LoggingProvider logging;
    private final System.Logger log;
    private final ConnectionProvider connectionProvider;
    private final MetricsListener metricsListener;
    private final Clock clock;
    private final ValueFactory valueFactory;
    private CompletableFuture<Void> closeFuture;

    public NettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, LoggingProvider logging, ValueFactory valueFactory, MetricsListener metricsListener) {
        Objects.requireNonNull(eventLoopGroup);
        this.clock = Objects.requireNonNull(clock);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.connectionProvider = ConnectionProviders.netty(eventLoopGroup, clock, domainNameResolver, localAddress, logging, valueFactory);
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.metricsListener = NoopMetricsListener.getInstance();
        InternalLoggerFactory.setDefaultFactory(new NettyLogging(logging));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<BoltConnection> connect(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, DatabaseName databaseName, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, AccessMode mode, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, Consumer<DatabaseName> databaseNameConsumer, Map<String, Object> additionalParameters) {
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
            }
        }
        CompletableFuture latestAuthMillisFuture = new CompletableFuture();
        AtomicReference authMapRef = new AtomicReference();
        return authTokenStageSupplier.get().thenCompose(authToken -> {
            authMapRef.set(authToken);
            return this.connectionProvider.acquireConnection(address, securityPlan, routingContext, databaseName != null ? (String)databaseName.databaseName().orElse(null) : null, authToken.asMap(), boltAgent, userAgent, mode, connectTimeoutMillis, impersonatedUser, latestAuthMillisFuture, notificationConfig, this.metricsListener);
        }).thenCompose(connection -> {
            if (minVersion != null && minVersion.compareTo(connection.protocol().version()) > 0) {
                return connection.close().thenCompose(ignored -> CompletableFuture.failedStage(new MinVersionAcquisitionException("lower version", connection.protocol().version())));
            }
            return CompletableFuture.completedStage(connection);
        }).handle((connection, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                this.log.log(System.Logger.Level.DEBUG, "Failed to establish BoltConnection " + String.valueOf(address), (Throwable)throwable);
                throw new CompletionException((Throwable)throwable);
            }
            databaseNameConsumer.accept(databaseName);
            return new BoltConnectionImpl(connection.protocol(), (Connection)connection, connection.eventLoop(), (AuthToken)authMapRef.get(), latestAuthMillisFuture, routingContext, this.clock, this.logging, this.valueFactory);
        });
    }

    @Override
    public CompletionStage<Void> verifyConnectivity(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.connect(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, null, () -> CompletableFuture.completedStage(authToken), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}, Collections.emptyMap()).thenCompose(BoltConnection::close);
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.connect(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, null, () -> CompletableFuture.completedStage(authToken), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}, Collections.emptyMap()).thenCompose(boltConnection -> {
            boolean supports = boltConnection.protocolVersion().compareTo(BoltProtocolV4.VERSION) >= 0;
            return boltConnection.close().thenApply(ignored -> supports);
        });
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.connect(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, null, () -> CompletableFuture.completedStage(authToken), AccessMode.WRITE, Collections.emptySet(), null, null, null, ignored -> {}, Collections.emptyMap()).thenCompose(boltConnection -> {
            boolean supports = BoltProtocolV51.VERSION.compareTo(boltConnection.protocolVersion()) <= 0;
            return boltConnection.close().thenApply(ignored -> supports);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture == null) {
                this.closeFuture = CompletableFuture.completedFuture(null);
            }
            closeFuture = this.closeFuture;
        }
        return closeFuture;
    }
}

