/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.DomainNameResolver;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.MetricsListener;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.RoutingContext;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.ConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.NetworkConnection;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelConnectedListener;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.NettyChannelInitializer;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.NettyDomainNameResolverGroup;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.ConnectTimeoutHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.BoltProtocol;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.resolver.AddressResolverGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public final class NettyConnectionProvider
implements ConnectionProvider {
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final DomainNameResolver domainNameResolver;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;
    private final LocalAddress localAddress;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;

    public NettyConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, LoggingProvider logging, ValueFactory valueFactory) {
        this.eventLoopGroup = eventLoopGroup;
        this.clock = Objects.requireNonNull(clock);
        this.domainNameResolver = Objects.requireNonNull(domainNameResolver);
        this.addressResolverGroup = new NettyDomainNameResolverGroup(this.domainNameResolver);
        this.localAddress = localAddress;
        this.logging = logging;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public CompletionStage<Connection> acquireConnection(BoltServerAddress address, SecurityPlan securityPlan, RoutingContext routingContext, String databaseName, Map<String, Value> authMap, BoltAgent boltAgent, String userAgent, AccessMode mode, int connectTimeoutMillis, String impersonatedUser, CompletableFuture<Long> latestAuthMillisFuture, NotificationConfig notificationConfig, MetricsListener metricsListener) {
        SocketAddress socketAddress;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeoutMillis)).channel(this.localAddress != null ? LocalChannel.class : NioSocketChannel.class)).resolver(this.addressResolverGroup).handler(new NettyChannelInitializer(address, securityPlan, connectTimeoutMillis, this.clock, this.logging));
        if (this.localAddress == null) {
            try {
                socketAddress = new InetSocketAddress(this.domainNameResolver.resolve(address.connectionHost())[0], address.port());
            }
            catch (Throwable t) {
                socketAddress = InetSocketAddress.createUnresolved(address.connectionHost(), address.port());
            }
        } else {
            socketAddress = this.localAddress;
        }
        return this.installChannelConnectedListeners(address, bootstrap.connect(socketAddress), connectTimeoutMillis).thenCompose(channel -> BoltProtocol.forChannel(channel).initializeChannel((Channel)channel, Objects.requireNonNull(userAgent), Objects.requireNonNull(boltAgent), authMap, routingContext, notificationConfig, this.clock, latestAuthMillisFuture, this.valueFactory)).thenApply(channel -> new NetworkConnection((Channel)channel, this.logging));
    }

    private CompletionStage<Channel> installChannelConnectedListeners(BoltServerAddress address, ChannelFuture channelConnected, int connectTimeoutMillis) {
        ChannelPipeline pipeline = channelConnected.channel().pipeline();
        channelConnected.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> pipeline.addFirst(new ConnectTimeoutHandler((long)connectTimeoutMillis))));
        CompletableFuture<Channel> handshakeCompleted = new CompletableFuture<Channel>();
        channelConnected.addListener(new ChannelConnectedListener(address, new ChannelPipelineBuilderImpl(), handshakeCompleted, this.logging, this.valueFactory));
        return handshakeCompleted.whenComplete((channel, throwable) -> {
            if (throwable == null) {
                channel.pipeline().remove(ConnectTimeoutHandler.class);
            }
        });
    }
}

