/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.ConnectionReadTimeoutHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.InboundMessageDispatcher;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.NoOpResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.BoltProtocol;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.Message;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.GoodbyeMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.util.LockUtil;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.EventLoop;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class NetworkConnection
implements Connection {
    private final System.Logger log;
    private final Lock lock;
    private final Channel channel;
    private final InboundMessageDispatcher messageDispatcher;
    private final String serverAgent;
    private final BoltServerAddress serverAddress;
    private final boolean telemetryEnabled;
    private final boolean ssrEnabled;
    private final BoltProtocol protocol;
    private final Duration defaultReadTimeout;
    private Duration readTimeout;
    private ChannelHandler connectionReadTimeoutHandler;

    public NetworkConnection(Channel channel, LoggingProvider logging) {
        this.log = logging.getLog(this.getClass());
        this.lock = new ReentrantLock();
        this.channel = channel;
        this.messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        this.serverAgent = ChannelAttributes.serverAgent(channel);
        this.serverAddress = ChannelAttributes.serverAddress(channel);
        this.telemetryEnabled = ChannelAttributes.telemetryEnabled(channel);
        this.ssrEnabled = ChannelAttributes.ssrEnabled(channel);
        this.protocol = BoltProtocol.forChannel(channel);
        this.readTimeout = this.defaultReadTimeout = (Duration)ChannelAttributes.connectionReadTimeout(channel).map(Duration::ofSeconds).orElse(null);
    }

    @Override
    public boolean isOpen() {
        return LockUtil.executeWithLock(this.lock, this.channel::isOpen);
    }

    @Override
    public void enableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(true);
        }
    }

    @Override
    public void disableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(false);
        }
    }

    @Override
    public CompletionStage<Void> write(Message message, ResponseHandler handler) {
        return this.writeMessageInEventLoop(message, handler);
    }

    @Override
    public CompletionStage<Void> flush() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.channel.eventLoop().execute(() -> {
            this.channel.flush();
            future.complete(null);
        });
        return future;
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    @Override
    public boolean isSsrEnabled() {
        return this.ssrEnabled;
    }

    @Override
    public String serverAgent() {
        return this.serverAgent;
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    @Override
    public BoltProtocol protocol() {
        return this.protocol;
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.eventLoop().execute(() -> {
            ChannelAttributes.setTerminationReason(this.channel, reason);
            this.channel.close().addListener(future -> {
                if (future.isSuccess()) {
                    fut.complete(null);
                } else {
                    Throwable cause = future.cause();
                    if (cause == null) {
                        cause = new IllegalStateException("Unexpected state");
                    }
                    fut.completeExceptionally(cause);
                }
            });
        });
        return fut;
    }

    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        this.writeMessageInEventLoop(GoodbyeMessage.GOODBYE, new NoOpResponseHandler()).thenCompose(ignored -> this.flush()).whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                this.channel.close().addListener(future -> {
                    if (future.isSuccess()) {
                        closeFuture.complete(null);
                    } else {
                        closeFuture.completeExceptionally(future.cause());
                    }
                });
            } else {
                closeFuture.completeExceptionally((Throwable)throwable);
            }
        });
        return closeFuture;
    }

    @Override
    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    @Override
    public Optional<Duration> defaultReadTimeoutMillis() {
        return Optional.ofNullable(this.defaultReadTimeout);
    }

    @Override
    public void setReadTimeout(Duration duration) {
        if (!this.channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        this.readTimeout = duration != null && duration.toMillis() > 0L ? duration : this.defaultReadTimeout;
    }

    private CompletionStage<Void> writeMessageInEventLoop(Message message, ResponseHandler handler) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable runnable = () -> {
            if (this.messageDispatcher.fatalErrorOccurred() && GoodbyeMessage.GOODBYE.equals(message)) {
                future.complete(null);
                handler.onSuccess(Collections.emptyMap());
                this.channel.close();
                return;
            }
            this.messageDispatcher.enqueue(handler);
            this.channel.write(message).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeFuture -> {
                if (writeFuture.isSuccess()) {
                    this.registerConnectionReadTimeout(this.channel);
                } else {
                    future.completeExceptionally(writeFuture.cause());
                }
            }));
            future.complete(null);
        };
        if (this.channel.eventLoop().inEventLoop()) {
            runnable.run();
        } else {
            this.channel.eventLoop().execute(runnable);
        }
        return future;
    }

    private void setAutoRead(boolean value) {
        this.channel.config().setAutoRead(value);
    }

    private void registerConnectionReadTimeout(Channel channel) {
        if (!channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        if (this.readTimeout != null && this.connectionReadTimeoutHandler == null) {
            this.connectionReadTimeoutHandler = new ConnectionReadTimeoutHandler(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
            channel.pipeline().addFirst(this.connectionReadTimeoutHandler);
            this.log.log(System.Logger.Level.DEBUG, "Added ConnectionReadTimeoutHandler");
            this.messageDispatcher.setBeforeLastHandlerHook(() -> {
                channel.pipeline().remove(this.connectionReadTimeoutHandler);
                this.connectionReadTimeoutHandler = null;
                this.messageDispatcher.setBeforeLastHandlerHook(null);
                this.log.log(System.Logger.Level.DEBUG, "Removed ConnectionReadTimeoutHandler");
            });
        }
    }
}

