/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltServiceUnavailableException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.BoltProtocolUtil;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelPipelineBuilder;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.HandshakeHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class ChannelConnectedListener
implements ChannelFutureListener {
    private final BoltServerAddress address;
    private final ChannelPipelineBuilder pipelineBuilder;
    private final CompletableFuture<Channel> handshakeCompletedFuture;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;

    public ChannelConnectedListener(BoltServerAddress address, ChannelPipelineBuilder pipelineBuilder, CompletableFuture<Channel> handshakeCompletedFuture, LoggingProvider logging, ValueFactory valueFactory) {
        this.address = address;
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedFuture = handshakeCompletedFuture;
        this.logging = logging;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (future.isSuccess()) {
            Channel channel = future.channel();
            ChannelActivityLogger log = new ChannelActivityLogger(channel, this.logging, this.getClass());
            log.log(System.Logger.Level.TRACE, "Channel %s connected, initiating bolt handshake", channel);
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new HandshakeHandler(this.pipelineBuilder, this.handshakeCompletedFuture, this.logging, this.valueFactory));
            log.log(System.Logger.Level.DEBUG, "C: [Bolt Handshake] %s", BoltProtocolUtil.handshakeString());
            channel.writeAndFlush(BoltProtocolUtil.handshakeBuf()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (!f.isSuccess()) {
                    Throwable error = f.cause();
                    if (!(error instanceof SSLHandshakeException)) {
                        error = new BoltServiceUnavailableException(String.format("Unable to write Bolt handshake to %s.", this.address), error);
                    }
                    this.handshakeCompletedFuture.completeExceptionally(error);
                }
            }));
        } else {
            this.handshakeCompletedFuture.completeExceptionally(ChannelConnectedListener.databaseUnavailableError(this.address, future.cause()));
        }
    }

    private static Throwable databaseUnavailableError(BoltServerAddress address, Throwable cause) {
        return new BoltServiceUnavailableException(String.format("Unable to connect to %s, ensure the database is running and that there is a working network connection to it.", address), cause);
    }
}

