/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltServiceUnavailableException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.BoltProtocolUtil;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelPipelineBuilder;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ManifestHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ManifestHandlerV1;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.logging.ChannelErrorLogger;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.BoltProtocol;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.jdbc.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.jdbc.internal.shaded.io.netty.handler.codec.ReplayingDecoder;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class HandshakeHandler
extends ReplayingDecoder<Void> {
    private final ChannelPipelineBuilder pipelineBuilder;
    private final CompletableFuture<Channel> handshakeCompletedFuture;
    private final LoggingProvider logging;
    private final ValueFactory valueFactory;
    private boolean failed;
    private ChannelActivityLogger log;
    private ChannelErrorLogger errorLog;
    private ManifestHandler manifestHandler;

    public HandshakeHandler(ChannelPipelineBuilder pipelineBuilder, CompletableFuture<Channel> handshakeCompletedFuture, LoggingProvider logging, ValueFactory valueFactory) {
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedFuture = handshakeCompletedFuture;
        this.logging = logging;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
        this.errorLog = new ChannelErrorLogger(ctx.channel(), this.logging);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.failed = false;
        this.log = null;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.log(System.Logger.Level.DEBUG, "Channel is inactive");
        if (!this.failed) {
            BoltServiceUnavailableException error = HandshakeHandler.newConnectionTerminatedError();
            this.fail(ctx, error);
        }
    }

    public static BoltServiceUnavailableException newConnectionTerminatedError() {
        return new BoltServiceUnavailableException("Connection to the database terminated. Please ensure that your database is listening on the correct host and port and that you have compatible encryption settings both on Neo4j server and driver. Note that the default encryption setting has changed in Neo4j 4.0.");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.errorLog.traceOrDebug("Another fatal error occurred in the pipeline", error);
        } else {
            this.failed = true;
            Throwable cause = HandshakeHandler.transformError(error);
            this.fail(ctx, cause);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.manifestHandler != null) {
            try {
                this.manifestHandler.decode(in);
            }
            catch (Throwable e) {
                this.fail(ctx, e);
            }
        } else {
            BoltProtocolVersion serverSuggestedVersion = BoltProtocolVersion.fromRawBytes(in.readInt());
            if (new BoltProtocolVersion(255, 1).equals(serverSuggestedVersion)) {
                this.log.log(System.Logger.Level.DEBUG, "S: [Bolt Handshake Manifest] v1", serverSuggestedVersion);
                this.manifestHandler = new ManifestHandlerV1(ctx.channel(), this.logging);
            } else {
                this.log.log(System.Logger.Level.DEBUG, "S: [Bolt Handshake] %s", serverSuggestedVersion);
                ctx.pipeline().remove(this);
                BoltProtocol protocol = this.protocolForVersion(serverSuggestedVersion);
                if (protocol != null) {
                    this.protocolSelected(serverSuggestedVersion, protocol.createMessageFormat(), ctx);
                } else {
                    this.handleUnknownSuggestedProtocolVersion(serverSuggestedVersion, ctx);
                }
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.manifestHandler != null) {
            ctx.pipeline().remove(this);
            try {
                BoltProtocol protocol = this.manifestHandler.complete();
                this.protocolSelected(protocol.version(), protocol.createMessageFormat(), ctx);
            }
            catch (Throwable e) {
                this.fail(ctx, e);
            }
        }
        super.channelReadComplete(ctx);
    }

    private BoltProtocol protocolForVersion(BoltProtocolVersion version) {
        try {
            return BoltProtocol.forVersion(version);
        }
        catch (BoltClientException e) {
            return null;
        }
    }

    private void protocolSelected(BoltProtocolVersion version, MessageFormat messageFormat, ChannelHandlerContext ctx) {
        ChannelAttributes.setProtocolVersion(ctx.channel(), version);
        this.pipelineBuilder.build(messageFormat, ctx.pipeline(), this.logging, this.valueFactory);
        this.handshakeCompletedFuture.complete(ctx.channel());
    }

    private void handleUnknownSuggestedProtocolVersion(BoltProtocolVersion version, ChannelHandlerContext ctx) {
        if (BoltProtocolUtil.NO_PROTOCOL_VERSION.equals(version)) {
            this.fail(ctx, HandshakeHandler.protocolNoSupportedByServerError());
        } else if (BoltProtocolVersion.isHttp(version)) {
            this.fail(ctx, HandshakeHandler.httpEndpointError());
        } else {
            this.fail(ctx, HandshakeHandler.protocolNoSupportedByDriverError(version));
        }
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.handshakeCompletedFuture.completeExceptionally(error)));
    }

    private static Throwable protocolNoSupportedByServerError() {
        return new BoltClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
    }

    private static Throwable httpEndpointError() {
        return new BoltClientException("Server responded HTTP. Make sure you are not trying to connect to the http endpoint (HTTP defaults to port 7474 whereas BOLT defaults to port 7687)");
    }

    private static Throwable protocolNoSupportedByDriverError(BoltProtocolVersion suggestedProtocolVersion) {
        return new BoltClientException("Protocol error, server suggested unexpected protocol version: " + String.valueOf(suggestedProtocolVersion));
    }

    private static Throwable transformError(Throwable error) {
        if (error instanceof DecoderException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof BoltServiceUnavailableException || error instanceof SSLHandshakeException) {
            return error;
        }
        return new BoltServiceUnavailableException("Failed to establish connection with the server", error);
    }
}

