/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.PullMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.summary.PullSummary;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public class PullResponseHandlerImpl
implements ResponseHandler {
    private final PullMessageHandler handler;
    private final ValueFactory valueFactory;

    public PullResponseHandlerImpl(PullMessageHandler handler, ValueFactory valueFactory) {
        this.handler = handler;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        boolean hasMore = metadata.getOrDefault("has_more", this.valueFactory.value(false)).asBoolean();
        this.handler.onSummary(new PullSummaryImpl(hasMore, metadata));
    }

    @Override
    public void onFailure(Throwable throwable) {
        this.handler.onError(throwable);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.handler.onRecord(fields);
    }

    public record PullSummaryImpl(boolean hasMore, Map<String, Value> metadata) implements PullSummary
    {
    }
}

