/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.MessageWithMetadata;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public class HelloMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 1;
    private static final String USER_AGENT_METADATA_KEY = "user_agent";
    private static final String BOLT_AGENT_METADATA_KEY = "bolt_agent";
    private static final String BOLT_AGENT_PRODUCT_KEY = "product";
    private static final String BOLT_AGENT_PLATFORM_KEY = "platform";
    private static final String BOLT_AGENT_LANGUAGE_KEY = "language";
    private static final String BOLT_AGENT_LANGUAGE_DETAIL_KEY = "language_details";
    private static final String ROUTING_CONTEXT_METADATA_KEY = "routing";
    private static final String PATCH_BOLT_METADATA_KEY = "patch_bolt";
    private static final String CREDENTIALS_KEY = "credentials";
    private static final String DATE_TIME_UTC_PATCH_VALUE = "utc";
    private final ValueFactory valueFactory;

    public HelloMessage(String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, Map<String, String> routingContext, boolean includeDateTimeUtc, NotificationConfig notificationConfig, boolean legacyNotifications, ValueFactory valueFactory) {
        super(HelloMessage.buildMetadata(userAgent, boltAgent, authMap, routingContext, includeDateTimeUtc, notificationConfig, legacyNotifications, valueFactory));
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public byte signature() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.metadata());
    }

    public String toString() {
        HashMap<String, Value> metadataCopy = new HashMap<String, Value>(this.metadata());
        metadataCopy.replace(CREDENTIALS_KEY, this.valueFactory.value("******"));
        return "HELLO " + String.valueOf(metadataCopy);
    }

    private static Map<String, Value> buildMetadata(String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, Map<String, String> routingContext, boolean includeDateTimeUtc, NotificationConfig notificationConfig, boolean legacyNotifications, ValueFactory valueFactory) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : authMap.entrySet()) {
            result.put(entry.getKey(), valueFactory.value(entry.getValue()));
        }
        if (userAgent != null) {
            result.put(USER_AGENT_METADATA_KEY, valueFactory.value(userAgent));
        }
        if (boltAgent != null) {
            HashMap<String, String> boltAgentMap = HelloMessage.toMap(boltAgent);
            result.put(BOLT_AGENT_METADATA_KEY, valueFactory.value(boltAgentMap));
        }
        if (routingContext != null) {
            result.put(ROUTING_CONTEXT_METADATA_KEY, valueFactory.value(routingContext));
        }
        if (includeDateTimeUtc) {
            result.put(PATCH_BOLT_METADATA_KEY, valueFactory.value(Collections.singleton(DATE_TIME_UTC_PATCH_VALUE)));
        }
        MessageWithMetadata.appendNotificationConfig(result, notificationConfig, legacyNotifications, valueFactory);
        return result;
    }

    private static HashMap<String, String> toMap(BoltAgent boltAgent) {
        HashMap<String, String> boltAgentMap = new HashMap<String, String>();
        boltAgentMap.put(BOLT_AGENT_PRODUCT_KEY, boltAgent.product());
        if (boltAgent.platform() != null) {
            boltAgentMap.put(BOLT_AGENT_PLATFORM_KEY, boltAgent.platform());
        }
        if (boltAgent.language() != null) {
            boltAgentMap.put(BOLT_AGENT_LANGUAGE_KEY, boltAgent.language());
        }
        if (boltAgent.languageDetails() != null) {
            boltAgentMap.put(BOLT_AGENT_LANGUAGE_DETAIL_KEY, boltAgent.languageDetails());
        }
        return boltAgentMap;
    }
}

