/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v3;

import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.ClusterComposition;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseName;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseNameUtil;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.RoutingContext;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltUnsupportedFeatureException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.BeginTxResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.CommitTxResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.DiscardResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.HelloResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.PullResponseHandlerImpl;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.ResetResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.RollbackTxResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.RunResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.BoltProtocol;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.PullMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.BeginMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.CommitMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.DiscardMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.HelloMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.MultiDatabaseUtil;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.PullAllMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.ResetMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.RollbackMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.RunWithMetadataMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v3.MessageFormatV3;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.util.MetadataExtractor;
import org.neo4j.jdbc.internal.shaded.bolt.summary.BeginSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.DiscardSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.PullSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.RouteSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.RunSummary;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;

public class BoltProtocolV3
implements BoltProtocol {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(3, 0);
    public static final BoltProtocol INSTANCE = new BoltProtocolV3();
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_first");
    private static final String ROUTING_CONTEXT = "context";
    private static final String GET_ROUTING_TABLE = "CALL dbms.cluster.routing.getRoutingTable($context)";

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV3();
    }

    @Override
    public CompletionStage<Channel> initializeChannel(Channel channel, String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, RoutingContext routingContext, NotificationConfig notificationConfig, Clock clock, CompletableFuture<Long> latestAuthMillisFuture, ValueFactory valueFactory) {
        BoltException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage(exception);
        }
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, null, authMap, routingContext.toMap(), this.includeDateTimeUtcPatchInHello(), notificationConfig, this.useLegacyNotifications(), valueFactory) : new HelloMessage(userAgent, null, authMap, null, this.includeDateTimeUtcPatchInHello(), notificationConfig, this.useLegacyNotifications(), valueFactory);
        CompletableFuture<String> future = new CompletableFuture<String>();
        HelloResponseHandler handler = new HelloResponseHandler(future, channel, clock, latestAuthMillisFuture);
        ChannelAttributes.messageDispatcher(channel).enqueue(handler);
        channel.writeAndFlush(message, channel.voidPromise());
        return future.thenApply(ignored -> channel);
    }

    @Override
    public CompletionStage<Void> route(Connection connection, Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser, MessageHandler<RouteSummary> handler, Clock clock, LoggingProvider logging, ValueFactory valueFactory) {
        Query query = new Query(GET_ROUTING_TABLE, Map.of(ROUTING_CONTEXT, valueFactory.value(routingContext)));
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query.query(), query.parameters(), null, Collections.emptyMap(), DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, Collections.emptySet(), null, NotificationConfig.defaultConfig(), this.useLegacyNotifications(), logging, valueFactory);
        final CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        final CompletableFuture pullFuture = new CompletableFuture();
        ((CompletableFuture)((CompletableFuture)runFuture.thenCompose(ignored -> pullFuture)).thenApply(map -> {
            long ttl = ((Value)map.get("ttl")).asLong();
            long expirationTimestamp = clock.millis() + ttl * 1000L;
            if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
                expirationTimestamp = Long.MAX_VALUE;
            }
            LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
            for (Value serversMap : ((Value)map.get("servers")).values()) {
                String role = serversMap.get("role").asString();
                for (Value server : serversMap.get("addresses").values()) {
                    BoltServerAddress address = new BoltServerAddress(server.asString());
                    switch (role) {
                        case "WRITE": {
                            writers.add(address);
                            break;
                        }
                        case "READ": {
                            readers.add(address);
                            break;
                        }
                        case "ROUTE": {
                            routers.add(address);
                        }
                    }
                }
            }
            Value db = (Value)map.get("db");
            String name = null;
            if (db != null && !db.isNull()) {
                name = db.asString();
            }
            ClusterComposition clusterComposition = new ClusterComposition(expirationTimestamp, readers, writers, routers, name);
            return new RouteSummaryImpl(clusterComposition);
        })).whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RouteSummary)summary);
            }
        });
        return connection.write(runMessage, runHandler).thenCompose(ignored -> {
            PullAllMessage pullMessage = PullAllMessage.PULL_ALL;
            PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(new PullMessageHandler(){
                private Map<String, Value> routingTable;

                @Override
                public void onRecord(Value[] fields) {
                    if (this.routingTable == null) {
                        List<String> keys = ((RunSummary)runFuture.join()).keys();
                        this.routingTable = new HashMap<String, Value>(keys.size());
                        for (int i = 0; i < keys.size(); ++i) {
                            this.routingTable.put(keys.get(i), fields[i]);
                        }
                        this.routingTable = Collections.unmodifiableMap(this.routingTable);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    pullFuture.completeExceptionally(throwable);
                }

                @Override
                public void onSummary(PullSummary success) {
                    pullFuture.complete(this.routingTable);
                }
            }, valueFactory);
            return connection.write(pullMessage, pullHandler);
        });
    }

    @Override
    public CompletionStage<Void> beginTransaction(Connection connection, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig, MessageHandler<BeginSummary> handler, LoggingProvider logging, ValueFactory valueFactory) {
        BoltException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage(exception);
        }
        try {
            this.verifyDatabaseNameBeforeTransaction(databaseName);
        }
        catch (Exception error) {
            return CompletableFuture.failedFuture(error);
        }
        CompletableFuture<BeginSummary> beginTxFuture = new CompletableFuture<BeginSummary>();
        BeginMessage beginMessage = new BeginMessage(bookmarks, txTimeout, txMetadata, databaseName, accessMode, impersonatedUser, txType, notificationConfig, this.useLegacyNotifications(), logging, valueFactory);
        beginTxFuture.whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((BeginSummary)summary);
            }
        });
        return connection.write(beginMessage, new BeginTxResponseHandler(beginTxFuture));
    }

    @Override
    public CompletionStage<Void> commitTransaction(Connection connection, MessageHandler<String> handler) {
        CompletableFuture<String> commitFuture = new CompletableFuture<String>();
        commitFuture.whenComplete((bookmark, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((String)bookmark);
            }
        });
        return connection.write(CommitMessage.COMMIT, new CommitTxResponseHandler(commitFuture));
    }

    @Override
    public CompletionStage<Void> rollbackTransaction(Connection connection, MessageHandler<Void> handler) {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        rollbackFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        return connection.write(RollbackMessage.ROLLBACK, new RollbackTxResponseHandler(rollbackFuture));
    }

    @Override
    public CompletionStage<Void> reset(Connection connection, MessageHandler<Void> handler) {
        CompletableFuture<Void> resetFuture = new CompletableFuture<Void>();
        resetFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary(null);
            }
        });
        ResetResponseHandler resetHandler = new ResetResponseHandler(resetFuture);
        return connection.write(ResetMessage.RESET, resetHandler);
    }

    @Override
    public CompletionStage<Void> telemetry(Connection connection, Integer api, MessageHandler<Void> handler) {
        return CompletableFuture.failedStage(new BoltUnsupportedFeatureException("telemetry not supported"));
    }

    @Override
    public CompletionStage<Void> runAuto(Connection connection, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, String query, Map<String, Value> parameters, Set<String> bookmarks, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig, MessageHandler<RunSummary> handler, LoggingProvider logging, ValueFactory valueFactory) {
        try {
            this.verifyDatabaseNameBeforeTransaction(databaseName);
        }
        catch (Exception error) {
            return CompletableFuture.failedFuture(error);
        }
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query, parameters, txTimeout, txMetadata, databaseName, accessMode, bookmarks, impersonatedUser, notificationConfig, this.useLegacyNotifications(), logging, valueFactory);
        CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        runFuture.whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RunSummary)summary);
            }
        });
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        return connection.write(runMessage, runHandler);
    }

    @Override
    public CompletionStage<Void> run(Connection connection, String query, Map<String, Value> parameters, MessageHandler<RunSummary> handler) {
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.unmanagedTxRunMessage(query, parameters);
        CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        runFuture.whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RunSummary)summary);
            }
        });
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        return connection.write(runMessage, runHandler);
    }

    @Override
    public CompletionStage<Void> pull(Connection connection, long qid, long request, PullMessageHandler handler, ValueFactory valueFactory) {
        PullAllMessage pullMessage = PullAllMessage.PULL_ALL;
        PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(handler, valueFactory);
        return connection.write(pullMessage, pullHandler);
    }

    @Override
    public CompletionStage<Void> discard(Connection connection, long qid, long number, MessageHandler<DiscardSummary> handler, ValueFactory valueFactory) {
        DiscardMessage discardMessage = new DiscardMessage(number, qid, valueFactory);
        CompletableFuture<DiscardSummary> discardFuture = new CompletableFuture<DiscardSummary>();
        discardFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((DiscardSummary)ignored);
            }
        });
        DiscardResponseHandler discardHandler = new DiscardResponseHandler(discardFuture);
        return connection.write(discardMessage, discardHandler);
    }

    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
        MultiDatabaseUtil.assertEmptyDatabaseName(databaseName, this.version());
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    protected boolean includeDateTimeUtcPatchInHello() {
        return false;
    }

    protected BoltException verifyNotificationConfigSupported(NotificationConfig notificationConfig) {
        BoltUnsupportedFeatureException exception = null;
        if (notificationConfig != null && !notificationConfig.equals(NotificationConfig.defaultConfig())) {
            exception = new BoltUnsupportedFeatureException(String.format("Notification configuration is not supported on Bolt %s", this.version().toString()));
        }
        return exception;
    }

    protected boolean useLegacyNotifications() {
        return true;
    }

    public record Query(String query, Map<String, Value> parameters) {
    }

    private record RouteSummaryImpl(ClusterComposition clusterComposition) implements RouteSummary
    {
    }
}

